<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Http\Requests\CouponRequest;
use App\Repositories\Contracts\CouponRepositoryInterface;
use App\Traits\JsonResponseTrait;
use Illuminate\Http\Request;
use App\Models\Coupon;

class CouponController extends Controller
{
  use JsonResponseTrait;

  protected $couponRepository;

  public function __construct(CouponRepositoryInterface $couponRepository)
  {
    $this->middleware('permission:coupon-list|coupon-create|coupon-edit|coupon-delete', ['only' => ['index', 'show', 'couponListAll']]);
    $this->middleware('permission:coupon-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:coupon-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:coupon-delete', ['only' => ['destroy']]);

    $this->couponRepository = $couponRepository;
  }

  public function index()
  {
    $allCoupons = $this->couponRepository->all();
    return view('admin.coupons.index', compact('allCoupons'));
  }

  public function couponListAll(Request $request)
  {
    return $this->couponRepository->allCoupons($request);
  }

  public function create()
  {
    return view('/admin/coupons/create');
  }
  public function edit($id)
  {
    $coupon = Coupon::findOrFail(decrypt($id));
    return view('admin.coupons.create', compact('coupon'));
  }

  public function show($id)
  {
    $coupon = $this->couponRepository->find($id);
    return view('admin.coupons.show', compact('coupon'));
  }

  public function store(CouponRequest $request)
  {
    return $this->couponRepository->store($request);
  }

  public function update(CouponRequest $request, $id)
  {
    return $this->couponRepository->updateCoupon($request, $id);
  }

  public function destroy($id)
  {
    $this->couponRepository->delete($id);
    return $this->successResponse($id, __('locale.Coupon Deleted Successfully'));
  }

  public function changeStatus()
  {
    $coupon = $this->couponRepository->toggleStatus(request('id'), request('status'));
    return $this->successResponse($coupon, __('locale.Coupon Status Changes Successfully'));
  }


  public function get_coupon_form(Request $request)
  {
    $type = $request->coupon_type;
    if (!$type) {
      abort(404, 'Coupon type is required');
    }
    $basePath = 'admin.coupons.';
    $viewName = $basePath . $type . '_coupon';
    if (!empty($request->id)) {
      $viewName .= ''; //if edit is different blade
      $coupon = Coupon::findOrFail($request->id);
      return view($viewName, compact('coupon'));
    }
    return view($viewName);
  }


}
