<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Repositories\Contracts\CarRepositoryInterface;
use App\Traits\JsonResponseTrait;
use Illuminate\Http\Request;
use App\Http\Requests\CarRequest;
use App\Models\Car;
class CarController extends Controller
{
  use JsonResponseTrait;

  protected $carRepository;

  public function __construct(CarRepositoryInterface $carRepository)
  {
    $this->middleware('permission:rental-list|rental-create|rental-edit|rental-delete', ['only' => ['index', 'show', 'carListAll']]);
    $this->middleware('permission:rental-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:rental-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:rental-delete', ['only' => ['destroy']]);

    $this->carRepository = $carRepository;
  }

  public function index()
  {
    $data = $this->carRepository->allCars();
    $parentCategories = $data['categories'];
    $brands = $data['brands'];
    $models = $data['models'];
    return view('admin.cars.index', compact('parentCategories', 'brands', 'models'));
  }

  public function carListAll(Request $request)
  {
    $filters = $request->only([
      'vehicle_parent_category_id',
      'vehicle_category_id',
      'vehicle_brand_id',
      'vehicle_model_id',
      'vehicle_color',
    ]);
    return $this->carRepository->all($filters, true);
  }

  public function create()
  {
    return view('/admin/cars/create');
  }
  public function edit(int $id)
  {
    $car = Car::findOrFail($id);
    return view('admin.cars.create', compact('car'));
  }
  public function show(Request $request, $id)
  {
    $car = $this->carRepository->find($id);
    $breadcrumbs = [
      'Home' => route('admin.dashboard'),
      'Car' => route('cars.index'),
      $car->license_plate => null, // last one is active
    ];
    return view('/admin/cars/show', compact('car', 'id', 'breadcrumbs'));
  }

  public function store(CarRequest $request)
  {
    $car = $this->carRepository->store($request, null);
    return $this->successResponse($car, __('locale.Car data submitted successfully!'));
  }
  public function update(CarRequest $request, int $id)
  {
    $car = $this->carRepository->store($request, $id);
    return $this->successResponse($car, __('locale.Car data updated successfully!'));
  }

  public function changeStatus(Request $request, $id)
  {

    $status = $request->post('status');
    $this->carRepository->toggleStatus($id, $status);
    return $this->successResponse(['id' => $id, 'status' => $status], __('locale.Car Status Changed Successfully'));
  }


}
