<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\CalendarEventRequest;
use App\Models\CalendarEvent;
use App\Traits\JsonResponseTrait;
class CalenderAppController extends Controller
{
  use JsonResponseTrait;
  function __construct()
  {
    $this->middleware('permission:event-list|event-create|event-edit|event-delete', ['only' => ['index', 'list']]);
    $this->middleware('permission:user-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:user-edit', ['only' => ['edit', 'update']]);
    $this->middleware('permission:user-delete', ['only' => ['destroy']]);

  }
  public function index()
  {
    return view('common.app-calendar');
  }
  public function list(Request $request)
  {
    $query = CalendarEvent::query();
    return response()->json($query->get());

  }

  public function store(CalendarEventRequest $request)
  {
    $event = CalendarEvent::create($request->all());
    return $this->successResponse($event, __('locale.Event added successfully'));
  }

  public function update(CalendarEventRequest $request, $id)
  {
    $event = CalendarEvent::findOrFail($id);
    $event->update($request->all());
    return $this->successResponse($event, __('locale.Event updated successfully'));
  }

  public function destroy($id)
  {
    CalendarEvent::findOrFail($id)->delete();
    return $this->successResponse($id, __('locale.Event deleted successfully'));
  }
}
