<?php
namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use App\Models\Faq;
use App\Models\Setting;

class WebviewController extends Controller
{

    public function faqs()
    {
       $faqs = Faq::where('status', 'Enable')->get();
        return view('webview.faqs')->with(compact('faqs'));
    }

    public function about()
    {
        $about = Setting::where('meta_key', 'about_us')->first();
        return view('webview.about')->with(compact('about'));
    }

    public function privacy()
    {
        $privacy = Setting::where('meta_key', 'privacy_policy')->first();
        return view('webview.privacy')->with(compact('privacy'));
    }

    public function term()
    {
        $terms = Setting::where('meta_key', 'terms')->first();
        return view('webview.terms')->with(compact('terms'));
    }
}
