<?php
namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Contact;
use Illuminate\Support\Facades\Validator;
use Session;
use Illuminate\Support\Facades\Notification;
use App\Notifications\UserNotification;
use Illuminate\Support\Facades\Mail;
use App\Mail\SupportEmail;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Http;
class FrontendController extends Controller
{
  public function index()
  {
    $pageConfigs = ['pageHeader' => false];
    return view('/frontend/index', ['pageConfigs' => $pageConfigs]);  //change to index
  }
  public function aboutUs()
  {
    $pageConfigs = ['pageHeader' => false];
    return view('/frontend/about-us', ['pageConfigs' => $pageConfigs]);  //change to index
  }
  public function contactUs()
  {
    $pageConfigs = ['pageHeader' => false];
    return view('/frontend/contact-us', ['pageConfigs' => $pageConfigs]);  //change to index
  }
  public function downloadApp()
  {
    $pageConfigs = ['pageHeader' => false];
    return view('/frontend/download-app', ['pageConfigs' => $pageConfigs]);  //change to index
  }
  public function appFeature()
  {
    $pageConfigs = ['pageHeader' => false];
    return view('/frontend/app-features', ['pageConfigs' => $pageConfigs]);  //change to index
  }

  public function createTicket(Request $request)
  {
    $rules = array(
      'person_name' => 'required|min:3',
      'person_email' => 'required|email',
      'phone' => ['nullable'],
      'subject' => 'required|min:3|max:200', // max 200 characters
      'message' => [
        'required',
        'string',
        'max:2000', // adjust limit as needed
        'not_regex:/<script\b[^>]*>(.*?)<\/script>/i', // block <script> tags
        'not_regex:/<\/?[a-z][\s\S]*>/i', // block all HTML tags (optional)
      ],
    );
    $messages = [
      'message.not_regex' => 'Script tags or HTML are not allowed in the message.',
    ];
    $validator = Validator::make($request->all(), $rules, $messages);
    if ($validator->fails()) {
      return Redirect::back()->withInput($request->all())->withErrors($validator)->withFragment('contact-us');
    } else {
      $response = Http::asForm()->post('https://www.google.com/recaptcha/api/siteverify', [
        'secret' => config('services.google.RECAPTCHA_SECRET'),
        'response' => $request->input('recaptcha_token'),
        'remoteip' => $request->ip(),
      ]);
      $body = $response->json();

      if (!isset($body['success']) || $body['success'] != true || $body['score'] < 0.5) {
        // Adjust score threshold (0.5 is typical)
        return redirect()->back()
          ->withErrors(['captcha' => 'Captcha verification failed.'])
          ->withInput();
      }
      $category = "Other";
      $contact = new Contact;
      $date = date('Y-m-d H:i:s'); //this returns the current date time
      $middle = strtotime($date);
      $un_id = 'T' . $middle;
      $contact->ticket_no = $un_id;
      $contact->user_id = !empty($request->user_id) ? $request->user_id : 0;
      $contact->email = $request->phone;
      $contact->username = $request->person_name;
      $contact->category = $category;
      $contact->subject = $request->subject;
      $contact->body = $request->message;
      $contact->status = 'Open';
      $contact->save();

      $admin = User::whereHas('roles', function ($query) {
        $query->where('name', '=', 'Admin');
      })->first();

      $details = [
        'body' => 'Dear admin, A new support ticket No. ' . $un_id . ' has been issued to a user ' . $request->person_email . ' dated ' . $date . '. Please review this ticket and take action.',
        'head' => 'Support Tickets',
        'request_id' => $contact->id,
        'user_id' => $admin->id,
        'type' => 'App\Notifications\Contact',
        'notifiable_type' => 'App\Models\User',
        'class' => 'feather icon-mail font-medium-5 warning',
        'color' => 'primary media-heading',
        'url' => 'admin/tickets',
        'sender_id' => !empty($request->user_id) ? $request->user_id : 0,
      ];
      $admins = User::where('user_type', 'Admin')->get();
      Notification::send($admins, new UserNotification($details));


      //send mail
      $array['view'] = 'emails.supportTicket';
      $array['subject'] = $request->subject;
      $array['name'] = $request->person_name;
      $array['data'] = $contact;
      $array['content'] = "Your ticket generated with ticket no " . $un_id . " Admin will contact you at the earliest.  ";
      try {
        Mail::to($request->person_email)->queue(new SupportEmail($array));
      } catch (\Exception $e) {
      }

      $validator = 'Ticket no: ' . $un_id . ' created successfully. Admin will contact you as soon as possible!';
      Session::flash('message', $validator);
      return redirect()->route('contact-us');
    }

  }

}
