<?php

namespace App\Http\Controllers\API;
use Illuminate\Http\Request;
use App\Models\Ride;
use App\Http\Controllers\Controller;
use App\Traits\ApiResponseTrait;
use App\Http\Resources\RideCollection;
use App\Http\Resources\RideResource;
use App\Http\Requests\SosAlertRequest;
use App\Http\Requests\RideRequestRequest;
use App\Http\Requests\UpdateLocationRequest;
use App\Http\Requests\ReviewRequest;
use App\Http\Requests\SosContactRequest;
use App\Http\Requests\WaitingTimeRequest;
use App\Repositories\Contracts\RideRepositoryInterface;
use App\Repositories\Contracts\RideRequestRepositoryInterface;
use App\Repositories\Contracts\ReviewRepositoryInterface;
use App\Repositories\Contracts\SosAlertRepositoryInterface;
class RideController extends Controller
{

  use ApiResponseTrait;
  protected $rideRepository, $rideRequestRepository, $reviewRepository, $sosAlertRepository;

  public function __construct(RideRepositoryInterface $rideRepository, RideRequestRepositoryInterface $rideRequestRepository, ReviewRepositoryInterface $reviewRepository, SosAlertRepositoryInterface $sosAlertRepository)
  {
    $this->rideRepository = $rideRepository;
    $this->rideRequestRepository = $rideRequestRepository;
    $this->reviewRepository = $reviewRepository;
    $this->sosAlertRepository = $sosAlertRepository;
  }

  public function index()
  {
    $query = $this->rideRepository->myRides();
    $collection = new RideCollection($query);
    $fullArray = $collection->response()->getData(true);
    return $this->successResponse(['data' => $fullArray['data'], 'links' => $fullArray['links'], 'meta' => $fullArray['meta']], __('locale.Data fetched successfully'));
  }

  public function rideDetail($id)
  {
    return new RideResource(Ride::with('driver', 'user', 'order.store', 'reviews', 'waitingTimes')->find($id));
  }

  public function requestRide(RideRequestRequest $request)
  {
    $temp = $this->rideRequestRepository->requestRide($request);
    return $this->successResponse($temp, __('locale.Request sent to drivers.'), 200);
  }

  public function cancelRideRequest(Request $request)
  {
    $this->rideRequestRepository->cancelTempRide($request->id);
    return $this->successResponse([], $result['message'] ?? __('locale.Ride request cancelled successfully.'), 200);
  }

  public function cancelRide(Request $request)
  {
    return $this->rideRepository->rideCancel($request);
  }

  public function respondToRequest(Request $request)
  {
    $result = $this->rideRepository->respondToRequest($request);
    if ($result['status'] == 400) {
      return $this->errorResponse(['id' => $result['ride_id'] ?? ''], $result['message'] ?? __('locale.Response recorded.'), 400);
    } else {
      return $this->successResponse(['id' => $result['ride_id'] ?? ''], $result['message'] ?? __('locale.Response recorded.'), 200);
    }

  }

  public function rideStart(Request $request, $rideId)
  {
    return $this->rideRepository->rideStart($request, $rideId);
  }

  public function rideEnd(Request $request, $rideId)
  {
    return $this->rideRepository->rideEnd($request, $rideId);
  }

  public function rideComplete(Request $request, $rideId)
  {
    return $this->rideRepository->rideComplete($request, $rideId);
  }

  public function markDelivered(Request $request, $orderId)
  {
    return $this->rideRepository->markDelivered($request, $orderId);
  }

  public function rideStatus(Request $request)
  {
    $this->rideRepository->rideStatus($request);
    return $this->successResponse([], __('locale.Ride status changes successfully.'), 200);
  }
  public function waitingTime(WaitingTimeRequest $request)
  {
    $this->rideRepository->waitingTime($request);
    return $this->successResponse([], __('locale.Ride status changes successfully.'), 200);
  }

  public function review(ReviewRequest $request, $rideId)
  {
    $data = $this->reviewRepository->store($request, $rideId, 'Ride');
    return $this->successResponse($data['review'] ?? [], $data['message'] ?? '', 200);
  }

  public function updateLocation(UpdateLocationRequest $request)
  {
    $this->rideRepository->updateLocation($request);
    return $this->successResponse([], __('updated'), 200);
  }

  public function lastDriverLocation($rideId)
  {
    $lastLoc = $this->rideRepository->lastDriverLocation($rideId);
    if ($lastLoc) {
      return $this->successResponse($lastLoc, __('updated'), 200);
    }
    return $this->errorResponse([], '', 400);
  }

  public function sosAlert(SosAlertRequest $request)
  {
    $this->sosAlertRepository->store($request);
    return $this->successResponse([], __('locale.SOS alert submitted successfully.'), 200);
  }

  public function sosAlertList()
  {
    $contacts = $this->sosAlertRepository->allContact();
    return $this->successResponse($contacts, __('locale.SOS contact list.'), 200);
  }

  public function sosAlertAdd(SosContactRequest $request)
  {
    return $this->sosAlertRepository->addContacts($request);
  }

  public function sosAlertDelete(Request $request)
  {
    $this->sosAlertRepository->delete($request->id);
    return $this->successResponse([], __('locale.SOS contact deleted successfully.'), 200);
  }

  public function rideRequestDriver()
  {
    $data = $this->rideRequestRepository->rideRequest();
    return $this->successResponse($data ?? [], __('Ride Request'), 200);
  }

  public function driverCurrentRide()
  {
    $data = $this->rideRepository->driverCurrentRide();
    return $this->successResponse($data ?? [], __('Driver Current Ride'), 200);
  }

  public function userCurrentRide()
  {
    $data = $this->rideRepository->userCurrentRide();
    return $this->successResponse($data ?? [], __('User Current Ride'), 200);
  }

  public function rateUser(Request $request, $rideId)
  {
    $data = $this->reviewRepository->store($request, $rideId, 'User');
    return $this->successResponse($data['review'] ?? [], $data['message'] ?? '', 200);
  }

}
