<?php
namespace App\Http\Controllers\API;
use App\Http\Controllers\Controller;
use App\Traits\ApiResponseTrait;
use App\Http\Requests\CartRequest;
use Illuminate\Http\Request;
use App\Services\CouponService;
use App\Repositories\Contracts\CartRepositoryInterface;
class CartController extends Controller
{

  use ApiResponseTrait;
  protected $cartRepo;
  protected $couponService;
  public function __construct(CartRepositoryInterface $cartRepo, CouponService $couponService)
  {
    $this->cartRepo = $cartRepo;
    $this->couponService = $couponService;
  }
  public function addCart(CartRequest $request)
  {
    return $this->cartRepo->addCart($request);
  }

  public function cartList(Request $request)
  {
    $cartData = $this->cartRepo->list($request);
    if (empty($cartData['items']) || $cartData['items']->isEmpty()) {
      return $this->successResponse([], __('locale.Your cart is empty.'), 400);
    }
    return $this->successResponse($cartData, __('locale.Cart fetched successfully.'), 200);
  }
  public function setAddress(Request $request)
  {
    return $this->cartRepo->setAddress($request);
  }
  public function setPayment(Request $request)
  {
    return $this->cartRepo->setPayment($request);
  }

  public function applyCoupon(Request $request)
  {
    $data = $this->couponService->applyCoupon($request);
    return $data;
  }

  public function removeCoupon(Request $request)
  {
    $data = $this->couponService->removeCoupon($request);
    return $data;
  }

  public function clearCart()
  {
    $deleted = $this->cartRepo->clear();
    if ($deleted) {
      return $this->successResponse([], __('locale.Cart cleared successfully.'), 400);
    }
    return $this->successResponse([], __('locale.Your cart is already empty.'), 200);
  }
}
