<?php

namespace App\Helpers;
use Illuminate\Support\Facades\Http;
class PaystackHelper
{
  public static function initializeTransaction($amount, $email, $callback_url, $metadata = [])
  {
    $secret = config('paystack.secret');
    $payload = [
      'email' => $email,
      'amount' => $amount, // in kobo
      'callback_url' => $callback_url,
      'metadata' => $metadata,
    ];
    $response = Http::withHeaders([
      'Authorization' => 'Bearer ' . $secret,
      'Accept' => 'application/json',
    ])->post('https://api.paystack.co/transaction/initialize', $payload);

    return $response->json();
  }

  public static function verifyTransaction($reference)
  {
    $secret = config('paystack.secret');
    $response = Http::withHeaders([
      'Authorization' => 'Bearer ' . $secret,
      'Accept' => 'application/json',
    ])->get("https://api.paystack.co/transaction/verify/{$reference}");
    return $response->json();
  }
}
