<?php

use Illuminate\Support\Facades\Cache;

if (!function_exists('cacheRemember')) {

  /**
   * Universal cache helper with optional tags.
   *
   * @param string $key Cache key
   * @param int $minutes Expiration in minutes
   * @param callable $callback Callback to generate value
   * @param array|null $tags Optional array of tags
   * @return mixed
   */
  function cacheRemember(string $key, int $minutes, callable $callback, ?array $tags = null)
  {
    $store = Cache::getDefaultDriver(); // current default cache driver

    // If driver supports tags and tags are provided
    if (!empty($tags) && in_array($store, ['redis', 'memcached'])) {
      return Cache::tags($tags)->remember($key, $minutes, $callback);
    }

    // Fallback: database or file cache (no tags)
    return Cache::store($store)->remember($key, $minutes, $callback);
  }
  if (!function_exists('cacheForget')) {

    /**
     * Forget a cache key with optional tags.
     *
     * @param string $key
     * @param array|null $tags
     * @return void
     */
    function cacheForget(string $key, ?array $tags = null)
    {
      $store = Cache::getDefaultDriver();

      if (!empty($tags) && in_array($store, ['redis', 'memcached'])) {
        Cache::tags($tags)->forget($key);
      } else {
        Cache::store($store)->forget($key);
      }
    }
  }

}
