<?php
namespace App\Events;

use App\Models\Subscription;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SubscriptionPaymentFailed
{
    use Dispatchable, SerializesModels;

    public Subscription $subscription;
    public string        $error;

    public function __construct(Subscription $subscription, string $error = '')
    {
        $this->subscription = $subscription;
        $this->error        = $error;
    }
}
