<?php

namespace App\Events;

use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;

class RideTakenEvent implements ShouldBroadcastNow
{
  use Dispatchable, InteractsWithSockets, SerializesModels;

  public $driverId;
  public $rideTempId;

  public function __construct($driverId, $rideTempId)
  {
    $this->driverId = $driverId;
    $this->rideTempId = $rideTempId;
  }

  public function broadcastOn()
  {
    return new PrivateChannel('driver.' . $this->driverId);
  }
  public function broadcastAs(): string
  {
    return 'ride.taken';
  }


  public function broadcastWith()
  {
    return [
      'ride_temp_id' => $this->rideTempId,
      'status' => 'Taken',
      'message' => __('locale.This ride has already been accepted by another driver.')
    ];
  }
}


/* Echo.private(`driver.${driverId}`)
  .listen('RideTakenEvent', (e) => {
    console.log('❌ Ride Taken:', e.ride_temp_id);
    // Remove/disable UI for this ride
    hideRideRequestCard(e.ride_temp_id);
  }); */
