<?php

namespace App\Events;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use App\Models\Order;
use Illuminate\Support\Facades\Log;
class OrderPlacedEvent implements ShouldBroadcastNow
{
  use Dispatchable, InteractsWithSockets, SerializesModels;

  public $order;

  public function __construct(Order $order)
  {
    $this->order = $order->load('store.user'); // eager load user if needed
  }

  /**
   * Get the channels the event should broadcast on.
   *
   * @return Channel|array
   */

  public function broadcastOn()
  {
    $storeOwnerId = $this->order->store?->user?->id;
    //Log::info('Broadcasting OrderPlacedEvent to channel: order.' . $storeOwnerId);
    return new PrivateChannel('order.' . $storeOwnerId);
  }

  public function broadcastAs(): string
  {
    return 'order.placed';
  }

  public function broadcastWith()
  {
    $order = $this->order;

    return [
      'id' => $order->id,
      'orderId' => $order->order_id,
      'createdAt' => $order->created_at->toDateTimeString(),
      'customer' => $order->user->name,
      'email' => $order->user->email,
      'avatar' => $order->user->profile_photo_url ?? null,
      'paymentStatus' => $order->payment_status,
      'currency' => $order->currency,
      'grandTotal' => $order->grand_total,
      'paymentType' => $order->payment_type,
      'status' => $order->status,
      'userType' => $order->user->user_type,
      'isRide' => $order->is_ride,
    ];
  }

}



/* Echo.private(`user.${userId}`)
  .listen('RideAcceptedEvent', (e) => {
    console.log('Ride Expired:', e.message);
    // show alert to user, allow retry, etc.
  }); */
