<?php

namespace App\Events;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class NotificationEvent implements ShouldBroadcastNow
{
  use Dispatchable, InteractsWithSockets, SerializesModels;

  public $body;
  public $head;
  public $user_id;
  public $request_id;
  public $sender_id;
  public $type;
  public $notifiable_type;
  public $class;
  public $color;
  public $url;
  public $tags;

  /**
   * Create a new event instance.
   *
   * @return void
   */

  public function __construct($data)
  {
    $this->body = $data['body'];
    $this->head = $data['head'];
    $this->user_id = $data['user_id'];
    $this->request_id = $data['request_id'];
    $this->sender_id = $data['sender_id'];
    $this->type = $data['type'];
    $this->notifiable_type = $data['notifiable_type'];
    $this->class = $data['class'];
    $this->color = $data['color'];
    $this->url = $data['url'];

  }

  /**
   * Get the channels the event should broadcast on.
   *
   * @return Channel|array
   */

  public function broadcastOn()
  {

    //return ['private-notification-'.$this->user_id];
    return new PrivateChannel('notification-' . $this->user_id);
  }

  public function broadcastAs()
  {
    return 'notifications';
  }
}
