<?php

namespace App\Events;

use App\Models\RideTemp;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class NewRideRequestEvent implements ShouldBroadcastNow
{
  use Dispatchable, InteractsWithSockets, SerializesModels;

  public $rideTemp;
  public $driverId;
  public $timeout;

  public function __construct(RideTemp $rideTemp, $driverId, int $timeout = 0)
  {
    $this->rideTemp = $rideTemp;
    $this->driverId = $driverId;
    $this->timeout = $timeout;
  }

  public function broadcastOn()
  {
    return new PrivateChannel('driver.' . $this->driverId);
  }

  public function broadcastAs(): string
  {
    return 'ride.new.request';
  }

  public function broadcastWith()
  {
    $user = $this->rideTemp->user;
    return [
      'ride_temp_id' => $this->rideTemp->id,
      'fare' => $this->rideTemp->currency . $this->rideTemp->fare,
      'distance' => $this->rideTemp->trip_distance,
      'trip_time' => $this->rideTemp->trip_time,
      'timer' => $this->timeout,
      'pickup' => $this->rideTemp->pickup_location,
      'drop' => $this->rideTemp->drop_location,
      'pickup_lat' => $this->rideTemp->pickup_lat,
      'pickup_lng' => $this->rideTemp->pickup_lng,
      'drop_lat' => $this->rideTemp->drop_lat,
      'drop_lng' => $this->rideTemp->drop_lng,
      // 👇 Add user details here
      'user' => [
        'name' => $user?->name,
        'image' => $user?->profile_photo_url,
        'rating' => $user?->rating,  // assuming 'rating' column exists in users table
      ],
    ];
  }
}


/* Echo.private(`driver.${driverId}`)
    .listen('NewRideRequestEvent', (e) => {
        console.log('🚖 New Ride Request:', e);
        // show popup/modal/notification to driver
    }); */
