<?php

namespace App\Events;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class ChatMessage implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $username;
    public $message;
    public $userid;
    public $conversationid;
    public $image;
    public $count;
    public $reciever_id;
    public $total_count;
    public $created_at;
    public $data;
    public $title;

    /**
     * Create a new event instance.
     *
     * @return void
    */

    public function __construct($data)
    {
        $this->username = $data['name'];
        $this->message  = $data['message'];
        $this->userid  = $data['userid'];
        $this->conversationid  = $data['conversationid'];
        $this->image  = $data['image'];
        $this->count  = $data['count'];
        $this->reciever_id  = $data['reciever_id'];
        $this->total_count  = $data['total_count'];
        $this->created_at  = $data['created_at'];
        $this->data  = $data['data'];
        $this->title  = $data['title'];
    }


    /**
     * Get the channels the event should broadcast on.
     *
     * @return Channel|array
    */

    public function broadcastOn()
    {
       //return ['private-message-'.$this->conversationid];
        return new PrivateChannel('message-'.$this->conversationid);  //add private- in PrivateChannel
    }

     public function broadcastAs()
    {
        return 'employeeMessages';
    }
}
