<header id="page-topbar">
    <div class="navbar-header">
        <div class="d-flex">
            <!-- LOGO -->
            <div class="navbar-brand-box">
                <a href="<?php echo e(route('dashboard.index')); ?>" class="logo logo-dark">
                    <span class="logo-sm">
                        <img src="<?php echo e(asset('assets/images/logo.jpeg')); ?>" alt="" height="22">
                    </span>
                    <span class="logo-lg">
                        <img src="<?php echo e(asset('assets/images/logo.jpeg')); ?>" alt="" height="17">
                    </span>
                </a>

                <a href="<?php echo e(route('dashboard.index')); ?>" class="logo logo-light mt-5">
                    <span class="logo-sm">
                        <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="">
                    </span>
                    <span class="logo-lg">
                        <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="" >
                    </span>
                    <!-- <h4 class="text-white">PESOS.MX</h4> -->

                </a>
            </div>

            <button type="button" class="btn btn-sm px-3 font-size-16 header-item waves-effect" id="vertical-menu-btn">
                <i class="fa fa-fw fa-bars"></i>
            </button>
        </div>

        <div class="d-flex">
           <div class="dropdown d-inline-block">
                <button type="button"
                        class="btn header-item waves-effect"
                        data-bs-toggle="dropdown">

                    <img src="<?php echo e(asset('assets/images/flags/' . app()->getLocale() . '.png')); ?>"
                        height="16"
                        class="me-1"
                        alt="lang">

                    <i class="mdi mdi-chevron-down"></i>
                </button>

                <div class="dropdown-menu dropdown-menu-end">
                    <a href="<?php echo e(route('change.language', 'es')); ?>"
                    class="dropdown-item <?php echo e(app()->getLocale()=='es'?'active':''); ?>">
                        <img src="<?php echo e(asset('assets/images/flags/es.png')); ?>" height="16" class="me-2">
                        Spanish
                    </a>

                    <a href="<?php echo e(route('change.language', 'en')); ?>"
                    class="dropdown-item <?php echo e(app()->getLocale()=='en'?'active':''); ?>">
                        <img src="<?php echo e(asset('assets/images/flags/en.png')); ?>" height="16" class="me-2">
                        English
                    </a>
                </div>
            </div>



            <div class="dropdown d-inline-block d-lg-none ms-2">
                <button type="button" class="btn header-item noti-icon waves-effect" id="page-header-search-dropdown"
                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="mdi mdi-magnify"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0" aria-labelledby="page-header-search-dropdown">
                    <form class="p-3">
                        <div class="form-group m-0">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="Search ..." aria-label="Recipient's username">
                                <div class="input-group-append">
                                    <button class="btn btn-primary" type="submit"><i class="mdi mdi-magnify"></i></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="dropdown d-inline-block">
                <button type="button" class="btn header-item noti-icon waves-effect" id="page-header-notifications-dropdown"
                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="bx bx-bell bx-tada"></i>
                    <span class="badge bg-danger rounded-pill">2</span>
                </button>
                <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0"
                    aria-labelledby="page-header-notifications-dropdown">
                    <div class="p-3">
                        <div class="row align-items-center">
                            <div class="col">
                                <h6 class="m-0" key="t-notifications"> <?php echo e(__('admin.notifications')); ?> </h6>
                            </div>
                            <div class="col-auto">
                                <a href="#" class="small" key="t-view-all"> <?php echo e(__('admin.view_all')); ?></a>
                            </div>
                        </div>
                    </div>
                    <div data-simplebar style="max-height: 230px;">
                       
                    </div>
                    <div class="p-2 border-top d-grid">
                        <a class="btn btn-sm btn-link font-size-14 text-center" href="#">
                            <i class="mdi mdi-arrow-right-circle me-1"></i> <span key="t-view-more"><?php echo e(__('admin.view_more')); ?>..</span> 
                        </a>
                    </div>
                </div>
            </div>

            <div class="dropdown d-inline-block">
                <?php
                    $user = auth()->user();
                    $imagePath = (!empty($user->image) && file_exists(public_path(USER_PATH . $user->image)))
                        ? asset(USER_PATH . $user->image)
                        : asset('assets/images/default-user.png'); // fallback image
                ?>

                <button type="button" class="btn header-item waves-effect" id="page-header-user-dropdown"
                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <img class="rounded-circle header-profile-user" src="<?php echo e($imagePath); ?>" alt="Header Avatar">
                        
                    <span class="d-none d-xl-inline-block ms-1" key="t-henry"><?php echo e(auth()->user()->name); ?></span>
                    <i class="mdi mdi-chevron-down d-none d-xl-inline-block"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <!-- item-->
                    <a class="dropdown-item" href="<?php echo e(route('profile')); ?>"><i class="bx bx-user font-size-16 align-middle me-1"></i> <span key="t-profile"><?php echo e(__('admin.profile')); ?></span></a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item text-danger" href="<?php echo e(route('logout')); ?>"><i class="bx bx-power-off font-size-16 align-middle me-1 text-danger"></i> <span key="t-logout"><?php echo e(__('admin.logout')); ?></span></a>
                </div>
            </div>
        </div>
    </div>
</header><?php /**PATH /home/intellisensetech/public_html/pesos/resources/views/layouts/header.blade.php ENDPATH**/ ?>