<?php $__env->startSection('css'); ?>
<style>
    .select2-container .select2-selection--single .select2-selection__rendered {
    color: var(--bs-emphasis-color);
}
.gallery-item {
    position: relative;
}

.remove-gallery-image {
    position: absolute;
    top: 6px;
    right: 10px;
    background: rgba(0,0,0,0.7);
    color: #fff;
    font-size: 18px;
    line-height: 18px;
    width: 22px;
    height: 22px;
    border-radius: 50%;
    text-align: center;
    cursor: pointer;
    z-index: 10;
}

.remove-gallery-image:hover {
    background: red;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-4">
                    <div class="page-title-box d-flex align-items-center">
                        <a href="<?php echo e(route('products.index')); ?>" class="btn btn-dark btn-sm mx-2"><i class="bx bx-arrow-back"></i> <?php echo e(__('admin.back')); ?></a>
                        <h4 class="mb-sm-0 font-size-18"><?php echo e(__('admin.update_product_details')); ?></h4>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title mb-4"><?php echo e(__('admin.update_product_details')); ?> </h4>
                          
                            <!----- Edit Product ------------>

                              <form method="POST" action="<?php echo e(route('products.update',$product->id)); ?>" enctype="multipart/form-data">
                                <?php echo method_field('put'); ?>
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.select_category')); ?></label>
                                             <select name="category" class="form-control select2 __category" data-route="<?php echo e(route('subcategory.service')); ?>" required>
                                                 <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php if($product->category_id == $key): ?> selected <?php endif; ?>>
                                                <?php echo e($value); ?>

                                            </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                              <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.select_subcategory')); ?></label>
                                              <select name="subcategory" class="form-control select2 __subcategory" data-selected="<?php echo e($product->subcategory_id); ?>" required>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                 <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.choose_brand')); ?></label>
                                             <select name="brand" class="form-control select2" required>
                                                <option value="" selected disabled><?php echo e(__('admin.select')); ?></option>
                                                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($key); ?>" <?php if($product->brand_id == $key): ?> selected <?php endif; ?>>
                                                        <?php echo e($value); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.name')); ?></label>
                                             <input type="text" name="name" placeholder="<?php echo e(__('admin.enter_item_name')); ?>" class="form-control" required value="<?php echo e($product->name); ?>">
                                        </div>
                                    </div>
                                   
                                </div>

                                <div class="row">
                                     <div class="col-md-6">
                                        <div class="mb-3">
                                              <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.price')); ?></label>
                                              <div class="input-group">
                                                    <span class="input-group-text"><?php echo e(env('CURRENCY_SYMBOL')); ?></span>
                                                    <input type="text" name="price" placeholder="<?php echo e(__('admin.enter_price')); ?>" class="form-control __numeric_decimal" required value="<?php echo e($product->price); ?>">
                                              </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.offer_price')); ?></label>
                                            <div class="input-group">
                                                    <span class="input-group-text"><?php echo e(env('CURRENCY_SYMBOL')); ?></span>
                                                    <input type="text" name="offer_price" placeholder="<?php echo e(__('admin.enter_offer_price')); ?>" class="form-control __numeric_decimal" required value="<?php echo e($product->offer_price); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                     <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.shipping_fee')); ?></label>
                                            <div class="input-group">
                                                    <span class="input-group-text"><?php echo e(env('CURRENCY_SYMBOL')); ?></span>
                                                    <input type="text" name="shipping_fee" placeholder="<?php echo e(__('admin.enter_shipping_fee')); ?>" class="form-control __numeric_decimal" required value="<?php echo e($product->shipping_fee); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.no_of_pieces_available')); ?></label>
                                             <input type="text" name="pieces_available" placeholder="<?php echo e(__('admin.no_of_pieces_available')); ?>" class="form-control __numeric" required value="<?php echo e($product->no_of_pieces_available); ?>" readonly>
                                        </div>
                                    </div>
                                
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.sku_number')); ?></label>
                                             <input type="text" name="sku_number" placeholder="<?php echo e(__('admin.enter_sku_number')); ?>" class="form-control" required value="<?php echo e($product->sku_number); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                              <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.barcode_number')); ?></label>
                                            <input type="text" name="barcode_number" placeholder="<?php echo e(__('admin.enter_barcode_number')); ?>" class="form-control" required value="<?php echo e($product->barcode_number); ?>">
                                        </div>
                                    </div>
                                </div>
                                   <div class="row">
                                        <div class="col-md-6">
                                        <div class="mb-3">
                                              <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.estimated_delivery_time')); ?></label>
                                              <div class="input-group">
                                                    <input type="text" name="estimated_delivery_time" placeholder="<?php echo e(__('admin.enter_no_of_days')); ?>" class="form-control __numeric" required value="<?php echo e($product->estimated_delivery_time); ?>">
                                                     <span class="input-group-text"><?php echo e(__('admin.days')); ?></span>
                                              </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.status')); ?></label>
                                             <select name="status" id="" class="form-select">
                                                <option value="1" <?php echo e($product->status == '1' ? 'selected' : ''); ?>><?php echo e(__('admin.active')); ?></option>
                                                <option value="0" <?php echo e($product->status == '0' ? 'selected' : ''); ?>><?php echo e(__('admin.inactive')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                 <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.cover_image')); ?></label>
                                             <input type="file" name="cover_image" class="form-control" accept="image/*" onchange="previewCoverImage(this)">
                                              <div class="mt-2">
                                                <img id="coverPreview" class="img-thumbnail d-none" width="150">
                                            </div>
                                            <?php if($product->cover_image): ?>
                                                <?php
                                                    $imagePath = (!empty($product->cover_image) && file_exists(public_path(PRODUCTS_PATH . $product->cover_image)))
                                                        ? asset(PRODUCTS_PATH . $product->cover_image)
                                                        : asset('assets/images/no-image.jpg');
                                                ?>
                                                <img src="<?php echo e($imagePath); ?>" class="img-thumbnail preview-image" height="150" width="150" style="cursor:pointer" data-bs-toggle="modal"  data-bs-target="#imagePreviewModal">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                              <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.gallery_images')); ?></label>
                                            <input type="file" name="gallery_images[]" class="form-control" accept="image/*" onchange="previewGalleryImages(this)" multiple>
                                            <input type="hidden" name="removed_gallery_images" id="removedGalleryImages">

                                            <div id="galleryPreview" class="row mt-2"></div>
                                             <?php if(!empty($product->gallery)): ?>
                                             <?php $__currentLoopData = $product->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                     <?php
                                                    $gimage = (!empty($val->image) && file_exists(public_path(PRODUCTS_PATH . $val->image))) ? asset(PRODUCTS_PATH .$val->image)
                                                        : asset('assets/images/no-image.jpg');
                                                    ?>
                                            <div class="col-3 mb-3 gallery-item position-relative">
                                                <span class="remove-gallery-image" data-id="<?php echo e($val->id); ?>">×</span>
                                               <img src="<?php echo e($gimage); ?>" class="img-thumbnail preview-image mb-2" height="150" width="150" style="cursor:pointer" data-bs-toggle="modal" data-bs-target="#imagePreviewModal">
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                             <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                      <div class="col-md-6">
                                        <div class="mb-3">
                                              <label for="horizontal-email-input" class="col-sm-6 col-form-label"><?php echo e(__('admin.item_description')); ?></label>
                                             <textarea class="form-control"  id="descriptionEditor" name="description"><?php echo e($product->description); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="row d-flex justify-content-center my-5">
                                    <div class="col-sm-2">
                                        <div>
                                            <button type="submit" class="btn btn-primary w-md"><?php echo e(__('admin.submit')); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <!----- Edit Product ------------>
                        </div>
                        <!-- end card body -->
                    </div>
                    <!-- end card -->
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Image Preview Modal -->
<div class="modal fade" id="imagePreviewModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-body p-0 text-center">
                <img id="imagePreviewModalImg" src="" class="img-fluid w-100">
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.ckeditor.com/ckeditor5/40.2.0/classic/ckeditor.js"></script>
<script>
    //Editor
     ClassicEditor
        .create(document.querySelector('#descriptionEditor'), {
            toolbar: [
                'heading','|',
                'bold','italic','underline','|',
                'bulletedList','numberedList','|',
                'link','blockQuote','|',
                'undo','redo'
            ]
        })
        .then(editor => {
        const editable = editor.ui.view.editable.element;
        editable.style.height = '120px';
        editable.style.overflowY = 'auto';
    })
        .catch(error => {
            console.error(error);
        });
    //Previw uploaded images
    document.addEventListener('click', function (e) {
    if (e.target.classList.contains('preview-image')) {
        document.getElementById('imagePreviewModalImg').src = e.target.src;
    }
});
    //Auto load selected subcategory
    $(document).ready(function () {

    let categoryId = $('.__category').val();
    let selectedSubcategory = $('.__subcategory').data('selected');
    let route = $('.__category').data('route');

    if (categoryId && selectedSubcategory) {
        select2Change('.__subcategory', route, {
            category_id: categoryId,
            selected: selectedSubcategory
        });
    }
});
    $('body').on('change', '.__category', function (e) {
    var value = $(this).val();
    if ($('.__category').length > 0) {
        if (value != '') {
            let route = $(this).attr('data-route');
            console.log(route);
            let title = $(this).attr('data-title');
            if (title == undefined) {
                title = '-Select-';
            }

            let data = {
                category_id: value,
                title: title,
            };
            select2Change('.__subcategory', route, data);
        }
    }
});

    function previewCoverImage(input) {
        const preview = document.getElementById('coverPreview');
        const file = input.files[0];

        if (file) {
            preview.src = URL.createObjectURL(file);
            preview.classList.remove('d-none');
        }
    }
function previewGalleryImages(input) {
    const preview = document.getElementById('galleryPreview');
    preview.innerHTML = '';

    Array.from(input.files).forEach((file, index) => {
        const col = document.createElement('div');
        col.className = 'col-3 mb-3 position-relative gallery-item';

        const removeBtn = document.createElement('span');
        removeBtn.innerHTML = '×';
        removeBtn.className = 'remove-gallery-image';
        removeBtn.onclick = () => col.remove();

        const img = document.createElement('img');
        img.src = URL.createObjectURL(file);
        img.className = 'img-thumbnail preview-image w-100';
        img.dataset.bsToggle = "modal";
        img.dataset.bsTarget = "#imagePreviewModal";

        col.appendChild(removeBtn);
        col.appendChild(img);
        preview.appendChild(col);
    });
}


    //Remove gallery images
let removedGallery = [];

/* Remove existing image */
document.addEventListener('click', function (e) {
    if (e.target.classList.contains('remove-gallery-image')) {
        const imageId = e.target.dataset.id;

        if (confirm('Remove this image?')) {
            removedGallery.push(imageId);
            document.getElementById('removedGalleryImages').value = removedGallery.join(',');
            e.target.closest('.gallery-item').remove();
        }
    }
});

$('form').on('submit', function () {
    console.log('Subcategory value:', $('.__subcategory').val());
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/intellisensetech/public_html/pesos/resources/views/admin/products/edit.blade.php ENDPATH**/ ?>