<div class="table-responsive">
    <table class="dataTable dt-responsive table table-hover table-nowrap align-middle mb-0">
        <thead class="table-light">
            <tr>
                <th class="align-middle"><?php echo e(__('admin.serial_no')); ?></th>
                <th><?php echo __('admin.image'); ?></th>
                <th class="align-middle"><?php echo sorting('order_number', __('admin.order_number'), $sortOrder, $sortEntity); ?></th>
                <th class="align-middle"><?php echo sorting('customer', __('admin.customer'), $sortOrder, $sortEntity); ?></th>
                <th class="align-middle"><?php echo sorting('product', __('admin.product'), $sortOrder, $sortEntity); ?></th>
                <th class="align-middle"><?php echo sorting('status', __('admin.status'), $sortOrder, $sortEntity); ?></th>
                <th class="align-middle"><?php echo e(__('admin.created_at')); ?></th>
                <th class="align-middle"><?php echo e(__('admin.action')); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if(isset($result) && count($result) > 0): ?>
                <?php
                    $sr = pageIndex($result);
                ?>
                <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                 <?php
                    $imagePath = (!empty($row->product->cover_image) && file_exists(public_path(PRODUCTS_PATH . $row->product->cover_image)))
                        ? asset(PRODUCTS_PATH . $row->product->cover_image)
                        : asset('assets/images/no-image.jpg');
                ?>
                    <tr>
                        <td>
                            <?php echo e($sr); ?>

                        </td>
                         <td><img src="<?php echo e($imagePath); ?>" height="50" width="50"/></td>
                        <td><?php echo e($row->order_number); ?></td>
                        <td>
                            <b><?php echo __('admin.name'); ?></b> : <?php echo e($row->customer->name); ?>

                            <br><b><?php echo __('admin.email'); ?></b> : <?php echo e($row->customer->email); ?>

                            <br><b><?php echo __('admin.phone'); ?></b> : <?php echo e($row->customer->dial_code.' - '.$row->customer->phone); ?>

                        </td>
                        <td style="max-width:300px; white-space:normal;">
                            <b><?php echo __('admin.name'); ?></b> : <?php echo e($row->product->name); ?>

                            <br><b><?php echo __('admin.sku_number'); ?></b> : <?php echo e($row->product->sku_number); ?>

                        </td>
                        <td>
                            <select class="form-control" name="order_status" onchange="updateOrderStatus(<?php echo e($row->id); ?>, this.value)">
                                <?php $__currentLoopData = $statusList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php echo e($row->order_status == $key ? 'selected' : ''); ?>><?php echo e($val); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </td>
                        <td><?php echo e(date('d M,Y',strtotime($row->created_at))); ?></td>
                        <td>
                            <a href="<?php echo e(route('orders.show',$row->id)); ?>" class="btn btn-primary btn-sm btn-rounded waves-effect waves-light"><?php echo e(__('admin.view_details')); ?> <i class="bx bx-link-external"></i></a>
                             <!-- <a style="cursor: pointer; color:red" title="<?php echo __('admin.delete'); ?>" class="btn btn-outline-danger btn-sm __drop" href="javascript:void(0);" data-url="<?php echo route('category.destroy', $row->id); ?>" data-confirm="<?php echo __('admin.delete_confirmation_message'); ?>"><i class="fa fa-trash"></i></a> -->
                        </td>
                    </tr>
                    <?php
                        $sr++;
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <tr>
                    <td colspan="9" class="text-center"><?php echo e(__('admin.no_data_found')); ?></td>
                </tr>
            <?php endif; ?>
        </tbody>
        <?php if(isset($result) && count($result) > 0): ?>
        <tfoot>
            <tr>
                <td colspan="9">
                    <div class="row">
                        <div class="col-md-6"><?php echo $result->links('pagination::bootstrap-4'); ?></div>
                        <div class="col-md-6 text-end"><?php echo pageDetail($result); ?></div>
                    </div>
                </td>
            </tr>
        </tfoot>
        <h4 class="my-3"><?php echo e(__('admin.records_found')); ?> : <?php echo e($result->total()); ?></h4>
        <?php endif; ?>
    </table>
</div><?php /**PATH /home/intellisensetech/public_html/pesos/resources/views/admin/orders/pagination.blade.php ENDPATH**/ ?>