<?php

use App\Http\Controllers\Auth\NewPasswordController;
use App\Http\Controllers\Auth\PasswordResetLinkController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BrandsController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CustomersController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\OffersController;
use App\Http\Controllers\OrdersController;
use App\Http\Controllers\ProductsController;
use App\Http\Controllers\PromoCodesController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\SubCategoryController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;


Route::get('clear', function () {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('view:clear');
    dd('cleared');
});

Route::get('migrate-fresh', function () {
    Artisan::call('migrate:fresh');
    dd('migration fresh');
});

Route::get('migrate-up', function () {
    Artisan::call('migrate');
    dd('migration done');
});
Route::get('/', function () {
    return redirect('login');
});
Route::get('/change-language/{lang}', function ($lang) {
// dd(session()->all());
    if (! in_array($lang, config('app.locales'))) {
        abort(400);
    }
    session()->put('locale', $lang);

    return redirect()->back();

})->name('change.language');

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.post');
    // Route::get('/forgot-password', [AuthController::class, 'forgotPassword'])->name('password.request');
    Route::get('/forgot-password', [PasswordResetLinkController::class, 'create'])
    ->name('password.request');

    Route::post('/forgot-password', [PasswordResetLinkController::class, 'store'])
        ->name('password.email');

    Route::get('/reset-password/{token}', [NewPasswordController::class, 'create'])
        ->name('password.reset');

    Route::post('/reset-password', [NewPasswordController::class, 'store'])
        ->name('password.update');
});

Route::middleware('auth')->group(function () {
     Route::get('export/{page}',[ExportController::class,'export'])->name('export');

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard.index');
    Route::get('/dashboard/orders-graph', [DashboardController::class, 'ordersGraph']);

     Route::get('/profile', [SettingController::class, 'profile'])->name('profile');
    Route::post("/profile/update", [SettingController::class, 'updateProfile'])->name('profile.update');
     Route::get('/logout',[AuthController::class, 'logout'])->name('logout');

     //Category
     Route::resource('category', CategoryController::class);
     Route::post('category/status/{id?}', [CategoryController::class,'status'])->name('category.status');
     Route::post('category/toggle-all-status/{status?}', [CategoryController::class,'toggleAllStatus'])->name('category.toggle-all-status');

     //Subcategory
     Route::resource('subcategory', SubCategoryController::class);
     Route::post('subcategory/service', [SubCategoryController::class, 'service'])->name('subcategory.service');
     Route::post('subcategory/status/{id?}', [SubCategoryController::class,'status'])->name('subcategory.status');
     Route::post('subcategory/toggle-all-status/{status?}', [SubCategoryController::class,'toggleAllStatus'])->name('subcategory.toggle-all-status');

     //Brand
     Route::resource('brands',BrandsController::class);
     Route::post('brands/status/{id?}', [BrandsController::class,'status'])->name('brands.status');
     Route::post('brands/toggle-all-status/{status?}', [BrandsController::class,'toggleAllStatus'])->name('brands.toggle-all-status');

      //Products
     Route::resource('products', ProductsController::class);
     Route::post('products/status/{id?}', [ProductsController::class,'status'])->name('products.status');
     Route::post('products/toggle-all-status/{status?}', [ProductsController::class,'toggleAllStatus'])->name('products.toggle-all-status');
     Route::post('products/service', [ProductsController::class, 'service'])->name('products.service');
     Route::post('products/get-price', [ProductsController::class, 'getPrice'])->name('products.get-price');


     //Customers
     Route::resource('customers', CustomersController::class);
     Route::post('customers/status/{id?}', [CustomersController::class,'status'])->name('customers.status');
     Route::post('customers/toggle-all-status/{status?}', [CustomersController::class,'toggleAllStatus'])->name('customers.toggle-all-status');

     //Orders
     Route::resource('orders', OrdersController::class);
     Route::post('orders/update-order-status', [OrdersController::class, 'updateOrderStatus'])
    ->name('orders.update-order-status');
    //Settings
     Route::get('settings',[SettingController::class,'getSettings'])->name('settings.get-settings');
    Route::post('settings/update/{id}',[SettingController::class,'updateSettings'])->name('settings.update');

    //Special Offers
     Route::resource('offers', OffersController::class);
     Route::post('offers/status/{id?}', [OffersController::class,'status'])->name('offers.status');
     Route::post('offers/toggle-all-status/{status?}', [OffersController::class,'toggleAllStatus'])->name('offers.toggle-all-status');

     //Inventory
     Route::post('update-inventory', [ProductsController::class, 'updateInventory'])->name('update-inventory');
     Route::get('inventory', [InventoryController::class, 'index'])->name('inventory.index');

     //Promo Codes
     Route::resource('promo-codes', PromoCodesController::class);
     Route::post('promo-codes/status/{id?}', [PromoCodesController::class,'status'])->name('promo-codes.status');
     Route::post('promo-codes/toggle-all-status/{status?}', [PromoCodesController::class,'toggleAllStatus'])->name('promo-codes.toggle-all-status');


});