@extends('layouts.master')
@section('content')
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-4">
                    <div class="page-title-box d-flex align-items-center">
                        <a href="{{ route('orders.index') }}" class="btn btn-dark btn-sm mx-2"><i class="bx bx-arrow-back"></i> {{__('admin.back')}}</a>
                        <h4 class="mb-sm-0 font-size-18">{{__('admin.order_details')}}</h4>
                    </div>
                </div>
            </div>
           <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row align-items-center">

                                <!-- LEFT: Customer details -->
                                <div class="col-md-4 d-flex align-items-start">
                                    <div class="text-muted">
                                        <h5 class="mb-1">{{ $order->product->name }}</h5>
                                        @if($order->order_status == 0)
                                            <span class="badge bg-secondary">{{ __('admin.pending') }}</span>
                                        @elseif($order->order_status == 1)
                                            <span class="badge bg-warning">{{ __('admin.ordered') }}</span>
                                        @elseif($order->order_status == 2)
                                            <span class="badge bg-primary">{{ __('admin.shipped') }}</span>
                                        @elseif($order->order_status == 3)
                                            <span class="badge bg-success">{{ __('admin.delivered') }}</span>
                                        @endif
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

          
        </div>
    </div>
</div>

@endsection