<div class="table-responsive">
    <table class="dataTable dt-responsive table table-hover table-nowrap align-middle mb-0">
        <thead class="table-light">
            <tr>
                <th class="align-middle">{{__('admin.serial_no')}}</th>
                <th>{{__('admin.product')}}</th>
                <th>{{__('admin.stock_type')}}</th>
                <th>{{__('admin.quantity')}}</th>
                <th>{{__('admin.available_stock')}}</th>
                <th>{{__('admin.created_at')}}</th>
                <th>{{__('admin.action')}}</th>
            </tr>
        </thead>
        <tbody>
            @if(isset($result) && count($result) > 0)
                @php
                    $sr = pageIndex($result);
                @endphp
                @foreach ($result as $row)
                 
                    <tr>
                        <td>
                            {{ $sr }}
                        </td>
                        <td style="max-width:300px; white-space:normal;">{{$row->product->name ?? '-'}}</td>
                        <td>
                             @if($row->stock_type == 'in')
                             <span class="badge bg-success text-uppercase">
                               {{$row->stock_type}}
                             </span>
                            @elseif($row->stock_type == 'out')
                            <span class="badge bg-danger text-uppercase">{{$row->stock_type}}</span>
                            @endif
                        </td>
                        <td>{!! $row->quantity !!}</td>
                        <td>{!! $row->updated_stock !!}</td>
                        <td>{!! date('d M,Y h:i A',strtotime($row->created_at)) !!}</td>
                        <td>
                            <a href="{{route('products.show',$row->product_id)}}" class="btn btn-primary btn-sm btn-rounded waves-effect waves-light">{{__('admin.view_details')}} <i class="bx bx-link-external"></i></a>
                        </td>
                    </tr>
                    @php
                        $sr++;
                    @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="9" class="text-center">{{__('admin.no_data_found')}}</td>
                </tr>
            @endif
        </tbody>
        @if(isset($result) && count($result) > 0)
        <tfoot>
            <tr>
                <td colspan="9">
                    <div class="row">
                        <div class="col-md-6">{!! $result->links('pagination::bootstrap-4') !!}</div>
                        <div class="col-md-6 text-end">{!! pageDetail($result) !!}</div>
                    </div>
                </td>
            </tr>
        </tfoot>
        <h4 class="my-3">{{__('admin.records_found')}} : {{ $result->total() }}</h4>
        @endif
    </table>
</div>