@extends('layouts.master')

@section('css')
<link rel="stylesheet" href="{{asset('assets/libs/flags/intlTelInput.css')}}">
<style>
    .iti--allow-dropdown {
        width: 100% !important;
    }
</style>
@endsection
@section('content')
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-4">
                    <div class="page-title-box d-flex align-items-center">
                        <a href="{{ route('customers.index') }}" class="btn btn-dark btn-sm mx-2"><i class="bx bx-arrow-back"></i> {{__('admin.back')}}</a>
                        <h4 class="mb-sm-0 font-size-18">{{__('admin.customer_details')}}</h4>
                    </div>
                </div>
            </div>
           <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row align-items-center">

                                <!-- LEFT: Customer details -->
                                <div class="col-md-4 d-flex align-items-start">
                                    <div class="text-muted">
                                        <h5 class="mb-1">{{ $customer->name }}</h5>
                                        @if($customer->status)
                                            <span class="badge bg-success">{{ __('admin.active') }}</span>
                                        @else
                                            <span class="badge bg-danger">{{ __('admin.inactive') }}</span>
                                        @endif
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title mb-4">{{__('admin.update_customer_details')}} </h4>
                            <form method="POST" action="{{ route('customers.update',$customer->id) }}" enctype="multipart/form-data">
                                @method('put')
                                @csrf
                                <div class="row mb-4">
                                    <label for="horizontal-email-input" class="col-sm-3 col-form-label">{{__('admin.name')}}</label>
                                    <div class="col-sm-9">
                                        <input type="text" name="name" placeholder="{{__('admin.enter_customer_name')}}" value="{{ $customer->name }}" class="form-control">
                                    </div>
                                </div>
                                <div class="row mb-4">
                                    <label for="horizontal-email-input" class="col-sm-3 col-form-label">{{__('admin.email')}}</label>
                                    <div class="col-sm-9">
                                        <input type="email" name="email" placeholder="{{__('admin.enter_category_email')}}" value="{{ $customer->email }}" class="form-control">
                                    </div>
                                </div>
                                <div class="row mb-4">
                                    <label for="horizontal-email-input" class="col-sm-3 col-form-label">{{__('admin.phone')}}</label>
                                    <div class="col-sm-9">
                                        <input type="text" name="phone" id="phone" placeholder="{{__('admin.enter_customer_phone_number')}}" value="{{ $customer->phone }}" class="form-control">
                                         <input type="hidden" name="dial_code" id="dial_code" value="{{ $customer->dial_code }}"/>
                                         <input type="hidden" id="dial_code_iso" name="dial_code_iso" value="{{ $customer->dial_code_iso }}">
                                    </div>
                                </div>
                                
                                <div class="row mb-4">
                                    <label for="horizontal-email-input" class="col-sm-3 col-form-label">{{__('admin.status')}}</label>
                                    <div class="col-sm-9">
                                        <select name="status" id="" class="form-select">
                                            <option value="1" @if($customer->status == 1) selected @endif>{{__('admin.active')}}</option>
                                            <option value="0" @if($customer->status == 0) selected @endif>{{__('admin.inactive')}}</option>
                                        </select>
                                    </div>
                                </div>
                                 <div class="row mb-4">
                                    <label for="horizontal-email-input" class="col-sm-3 col-form-label">{{__('admin.profile_pic')}}</label>
                                    <div class="col-sm-9">
                                        <input type="file" name="image" class="form-control" accept="image/*" onchange="previewCoverImage(this)">
                                              <div class="mt-2">
                                                <img id="coverPreview" class="img-thumbnail d-none" width="150">
                                            </div>
                                            @if($customer->image)
                                                @php
                                                    $imagePath = (!empty($customer->image) && file_exists(public_path(CUSTOMERS_PATH . $customer->image)))
                                                        ? asset(CUSTOMERS_PATH . $customer->image)
                                                        : asset('assets/images/no-image.jpg');
                                                @endphp
                                                <img src="{{$imagePath}}" class="img-thumbnail preview-image" height="150" width="150" style="cursor:pointer" data-bs-toggle="modal"  data-bs-target="#imagePreviewModal">
                                            @endif
                                    </div>
                                </div>
                                <div class="row d-flex justify-content-center my-5">
                                    <div class="col-sm-2">
                                        <div>
                                            <button type="submit" class="btn btn-primary w-md">{{__('admin.submit')}}</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- end card body -->
                    </div>
                    <!-- end card -->
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
<script src="{{asset('assets/libs/flags/intlTelInput.js')}}"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {

    const input = document.getElementById("phone");
    const dialCodeInput = document.getElementById("dial_code");
    const dialCodeIsoInput = document.getElementById("dial_code_iso");

    const iti = window.intlTelInput(input, {
        initialCountry: "{{ strtolower($customer->dial_code_iso) }}",
        separateDialCode: true,
        utilsScript: "{{ asset('assets/libs/flags/utils.js') }}"
    });

    iti.setNumber("{{ $customer->dial_code }}{{ $customer->phone }}");

    input.addEventListener("countrychange", function () {
        const countryData = iti.getSelectedCountryData();
        dialCodeInput.value = '+' + countryData.dialCode;
        dialCodeIsoInput.value = countryData.iso2;
    });

    // ✅ Remove space before submit
    input.form.addEventListener("submit", function () {
        input.value = input.value.replace(/\s+/g, '');
    });

});
     function previewCoverImage(input) {
        const preview = document.getElementById('coverPreview');
        const file = input.files[0];

        if (file) {
            preview.src = URL.createObjectURL(file);
            preview.classList.remove('d-none');
        }
    }
</script>
@endsection