<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class SubCategory extends Model
{
    protected $guarded = [];
    protected $table = "subcategory";
    public $sortOrder = 'desc';
    public $sortEntity = 'subcategory.id';

    public function category()
    {
        return $this->belongsTo(Category::class,'category_id','id');
    }
    public function products()
    {
        return $this->hasMany(Products::class);
    }
    public function scopeActive($query)
    {
        return $query->where('subcategory.status', 1);
    }

    public function pagination(Request $request)
    {
        $filter = 1;
        $perPage = 10;
        $sortOrder = $this->sortOrder;
        $sortEntity = $this->sortEntity;

         
        $query = Subcategory::with('category'); // relation loaded
        if ($request->has('perPage') && $request->get('perPage') != '') {
            $perPage = $request->get('perPage');
        }
        if ($request->has('keyword') && $request->get('keyword') != '') {
            $filter .= " and (
                subcategory.name like '%" . addslashes($request->get('keyword')) . "%'
                or category.name like '%" . addslashes($request->get('keyword')) . "%')";
        }

       
        if ($request->has('status') && $request->get('status') != '') {
            $filter .= " and subcategory.status = '" . addslashes($request->get('status')) . "'";
        }

      
        if ($request->has('sortEntity') && $request->get('sortEntity') != '') {
            $sortEntity = $request->get('sortEntity');
        }

        if ($request->has('sortOrder') && $request->get('sortOrder') != '') {
            $sortOrder = $request->get('sortOrder');
        }
       
        $query->addSelect('subcategory.*')
        ->leftJoin('category','category.id','subcategory.category_id')
            ->whereRaw($filter)
            ->orderBy($sortEntity, $sortOrder);
        Cache::put(env('EXPORT_CACHE_KEY'), $request->all());
        $data = $query->paginate($perPage);
        return $data;
    }
     
    public function toggleStatus($status, $ids = [])
    {
        if (isset($ids) && count($ids) > 0) {
            return $this->whereIn('subcategory.id', $ids)->update(['status' => $status]);
        }
    }

    public function service($heading = true, $title = '-Select-', $search = [])
    {
        $filter = 1;
        if (isset($search) && count($search) > 0) {
            $f1 = (isset($search['category_id']) && $search['category_id'] != '') ?
                ' and subcategory.category_id = "' . addslashes($search['category_id']) . '"' : '';
            $filter .= $f1;
        }

        $result = $this
            ->whereRaw($filter)
            ->active()
            ->get(['id', 'name']);

        $service = [];
        if ($heading) {
            $service[''] = $title;
        }

        if (isset($result) && count($result) > 0) {
            foreach ($result as $row) {
                $service[$row->id] = $row->name;
            }
        }
        return $service;
    }
    

}
