<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class Products extends Model
{
    protected $guarded = [];
    protected $table = "products";
    public $sortOrder = 'desc';
    public $sortEntity = 'products.id';

     public function gallery()
    {
        return $this->hasMany(ProductGallery::class,'product_id','id');
    }
    public function orders()
    {
        return $this->hasMany(Orders::class,'product_id','id');
    }
     public function offer()
    {
        return $this->hasMany(Offers::class,'product_id','id');
    }
    public function category()
    {
        return $this->belongsTo(Category::class)->withDefault();;
    }
   public function inventory()
    {
        return $this->hasMany(Inventory::class,'product_id','id')->orderBy('id', 'desc');
    }

    /* Product belongs to Subcategory */
    public function subcategory()
    {
        return $this->belongsTo(SubCategory::class)->withDefault();
    }
    public function brands()
    {
        return $this->belongsTo(Brands::class,'brand_id')->withDefault();;
    }

    public function scopeActive($query)
    {
        return $query->where('products.status', 1);
    }
    public function pagination(Request $request)
    {
        $filter = 1;
        $perPage = 10;
        $sortOrder = $this->sortOrder;
        $sortEntity = $this->sortEntity;

         
        $query = Products::with('category','subcategory','brands'); // relation loaded
        if ($request->has('perPage') && $request->get('perPage') != '') {
            $perPage = $request->get('perPage');
        }
        if ($request->has('keyword') && $request->get('keyword') != '') {
            $filter .= " and (
                products.name like '%" . addslashes($request->get('keyword')) . "%'
                or products.sku_number like '%" . addslashes($request->get('keyword')) . "%'
                or products.barcode_number like '%" . addslashes($request->get('keyword')) . "%'
                or subcategory.name like '%" . addslashes($request->get('keyword')) . "%'
                or category.name like '%" . addslashes($request->get('keyword')) . "%')";
        }

       
        if ($request->has('status') && $request->get('status') != '') {
            $filter .= " and products.status = '" . addslashes($request->get('status')) . "'";
        }

      
        if ($request->has('sortEntity') && $request->get('sortEntity') != '') {
            $sortEntity = $request->get('sortEntity');
        }

        if ($request->has('sortOrder') && $request->get('sortOrder') != '') {
            $sortOrder = $request->get('sortOrder');
        }
       
        $query->addSelect('products.*')
        ->leftJoin('category','category.id','products.category_id')
        ->leftJoin('subcategory','subcategory.id','products.subcategory_id')
        ->leftJoin('brands','brands.id','products.brand_id')
            ->whereRaw($filter)
            ->orderBy($sortEntity, $sortOrder);
        Cache::put(env('EXPORT_CACHE_KEY'), $request->all());
        $data = $query->paginate($perPage);
        return $data;
    }
     
    public function toggleStatus($status, $ids = [])
    {
        if (isset($ids) && count($ids) > 0) {
            return $this->whereIn('products.id', $ids)->update(['status' => $status]);
        }
    }
    
      public function service($heading = true, $title = '-Select-', $search = [])
    {
        $filter = 1;
        if (isset($search) && count($search) > 0) {
            $f1 = (isset($search['subcategory_id']) && $search['subcategory_id'] != '') ?
                ' and products.subcategory_id = "' . addslashes($search['subcategory_id']) . '"' : '';
            $filter .= $f1;
        }

        $result = $this
            ->whereRaw($filter)
            ->active()
            ->get(['id', 'name']);

        $service = [];
        if ($heading) {
            $service[''] = $title;
        }

        if (isset($result) && count($result) > 0) {
            foreach ($result as $row) {
                $service[$row->id] = $row->name;
            }
        }
        return $service;
    }
    

}
