<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class Inventory extends Model
{
    protected $guarded = [];
    protected $table = "inventory";
    public $sortOrder = 'desc';
    public $sortEntity = 'inventory.id';

    public function product()
    {
        return $this->belongsTo(Products::class,'product_id','id');
    }
   public function pagination(Request $request)
    {
        $filter = 1;
        $perPage = 10;
        $sortOrder = $this->sortOrder;
        $sortEntity = $this->sortEntity;

         
        $query = Inventory::with('product'); // relation loaded
        if ($request->has('perPage') && $request->get('perPage') != '') {
            $perPage = $request->get('perPage');
        }
        if ($request->has('keyword') && $request->get('keyword') != '') {
            $filter .= " and (
                inventory.stock_type like '%" . addslashes($request->get('keyword')) . "%'
                or products.name like '%" . addslashes($request->get('keyword')) . "%')";
        }

        
       
        if ($request->has('stock_type') && $request->get('stock_type') != '') {
            $filter .= " and inventory.stock_type = '" . addslashes($request->get('stock_type')) . "'";
        }
         // Start Date
        if ($request->filled('start_date')) {
            $startDate = $request->start_date . ' 00:00:00';
            $filter .= " AND inventory.created_at >= '{$startDate}'";
        }

        // End Date
        if ($request->filled('end_date')) {
            $endDate = $request->end_date . ' 23:59:59';
            $filter .= " AND inventory.created_at <= '{$endDate}'";
        }

       if (($request->has('stock_type') && $request->get('stock_type') != '') && $request->filled('start_date')) 
        {
              $startDate = $request->start_date . ' 00:00:00';
              $filter .= " and inventory.stock_type = '" . addslashes($request->get('stock_type')) . "' and inventory.created_at >= '{$startDate}'";
        }
        if (($request->has('stock_type') && $request->get('stock_type') != '') && $request->filled('start_date') && $request->filled('end_date')) 
        {
              $startDate = $request->start_date . ' 00:00:00';
               $endDate = $request->end_date . ' 23:59:59';
              $filter .= " and inventory.stock_type = '" . addslashes($request->get('stock_type')) . "' AND inventory.created_at between '{$startDate}' and '{$endDate}'";
        }
       
      
        if ($request->has('sortEntity') && $request->get('sortEntity') != '') {
            $sortEntity = $request->get('sortEntity');
        }

        if ($request->has('sortOrder') && $request->get('sortOrder') != '') {
            $sortOrder = $request->get('sortOrder');
        }
       
        $query->addSelect('inventory.*')
         ->leftJoin('products', 'products.id', '=', 'inventory.product_id')
            ->whereRaw($filter)
            ->orderBy($sortEntity, $sortOrder);
        Cache::put(env('EXPORT_CACHE_KEY'), $request->all());
        $data = $query->paginate($perPage);
        return $data;
    }
    

}
