<?php

namespace App\Http\Controllers;

use App\Models\Orders;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OrdersController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
         $sortEntity = (new Orders())->sortEntity;
         $sortOrder = (new Orders())->sortOrder;
   
        $result = null;
        $statusList = orderStatus();
        if ($request->ajax()) {
            $sortEntity = $request->sortEntity;
            $sortOrder = $request->sortOrder;

            $result = (new Orders)->pagination($request);
           
            return view('admin.orders.pagination', compact('result', 'sortOrder', 'sortEntity','statusList'));
        }
        $url = url()->full();
        return view('admin.orders.index',compact('url','result', 'sortOrder', 'sortEntity','statusList'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.category.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
      
        $inputs = $request->all();
        $rules = [
            'name'              => 'required|string',
            'status'            =>  'in:0,1'
        ];
        $validation = validator($inputs, $rules);
        if ($validation->fails()) {
             return back()->withErrors($validation->getMessageBag());
        }

        $category  = Category::create([
            'name'           => $inputs['name'],
            'status'      => $inputs['status'],
        ]);
        return redirect()->route('category.index')->with('success', __('admin.category_created_successfully'));
    }

    /**
     * Display the specified resource.
     */
     public function show(Orders $order)
    {
        $order->load('customer','product');
        return view('admin.orders.show',compact('order'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Orders $order)
    {
       $validated = $request->validate([
            'name'          => 'nullable|string',
            'status'        => 'required|boolean',
        ]);

        $category->name  = $validated['name'];
        $category->status = $validated['status'];
        $category->save();

        return redirect()->back()->with('success', __('admin.category_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Orders $order)
    {
        $category->delete();
        return response()->json(['success' => true,'status'  => 201,'message' => __('admin.category_deleted_successfully'),
        'extra'   => ['redirect' => route('category.index')]]);
    }

   public function updateOrderStatus(Request $request)
{
    $request->validate([
        'order_id' => 'required|exists:orders,id',
        'order_status' => 'required|in:0,1,2,3',
    ]);

    $order = Orders::findOrFail($request->order_id);
    $order->order_status = $request->order_status;
    $order->save();

    return response()->json([
        'success' => true,
        'message' => __('admin.order_status_updated_successfully'),
    ]);
}
}
