<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\Inventory;
use App\Models\Orders;
use App\Models\Products;
use App\Models\Sale;
use App\Models\Vendor;
use App\Models\Voucher;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index(Request $request) 
    {
        $data['total_products'] = Products::where('status',1)->count();
        $data['total_pending_orders'] = Orders::where('order_status',0)->count();
        $data['total_in_process_orders'] = Orders::whereIn('order_status',[1,2])->count();
        $data['total_delivered_orders'] = Orders::where('order_status',3)->count();
        //Stock In/OUT
        $data['total_stock_in_today'] = Inventory::where('stock_type','in')->whereDate('created_at',Carbon::today())->sum('quantity');
        $data['total_stock_out_today'] = Inventory::where('stock_type','out')->whereDate('created_at',Carbon::today())->count();
        return view('admin.dashboard',$data);
    }

    public function ordersGraph(Request $request)
{
    $filter = $request->get('filter', 'yearly');

    if ($filter === 'weekly') {
        $data = Orders::selectRaw('DAYNAME(created_at) as label, COUNT(*) as total')
            ->whereBetween('created_at', [
                Carbon::now()->startOfWeek(),
                Carbon::now()->endOfWeek()
            ])
            ->groupBy('label')
            ->orderByRaw("FIELD(label,'Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday')")
            ->get();
    }

    elseif ($filter === 'yearly') {
        $data = Orders::selectRaw('MONTH(created_at) as month, COUNT(*) as total')
            ->whereYear('created_at', Carbon::now()->year)
            ->groupBy('month')
            ->orderBy('month')
            ->get()
            ->map(fn ($row) => [
                'label' => Carbon::create()->month($row->month)->format('M'),
                'total' => $row->total
            ]);
    }

    else { // monthly
        $data = Orders::selectRaw('DATE(created_at) as date, COUNT(*) as total')
            ->whereMonth('created_at', Carbon::now()->month)
            ->whereYear('created_at', Carbon::now()->year)
            ->groupBy('date')
            ->orderBy('date')
            ->get()
             ->map(fn ($row) => [
                'label' => Carbon::parse($row->date)->format('d M Y'),
                'total' => $row->total
            ]);
    }

    return response()->json([
        'labels' => $data->pluck('label'),
        'data'   => $data->pluck('total')
    ]);
}
}
