
<?php $__env->startSection('title', 'Order Detail'); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $currencySymbol = App\Helpers\CommonHelper::getCurrencyInfo($order->currency_code)->currency_symbol ?? '';
    ?>
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-lg-4 col-sm-6">
                <div class="card px-4 mb-4">
                    <div class="card-body px-0">
                        <h4 class="">Customer Detail</h4>

                        <div class="d-flex align-items-center">
                            <div class="customer-image">
                                <?php
                                    $image = DEFAULT_PATH;
                                    if (!empty($order->customer->image)) {
                                        $image = $order->customer->image;
                                    }

                                ?>

                                <img src="<?php echo e(asset($image)); ?>" alt="Customer Image" width="60" height="60"
                                    class="rounded-circle">
                            </div>
                            <div class="customer-info">
                                <p class="customer-name"><?php echo e($order->customer->full_name); ?></p>

                            </div>
                        </div>
                        <div class="customer-contact-wrapper">
                            <p class="customer-contact"><i class="fas fa-envelope"></i> <?php echo e($order->customer->email); ?>

                            </p>
                            <p class="customer-contact"><i class="fas fa-mobile-alt"></i>
                                <?php echo e($order->customer->mobile_number); ?>

                            </p>
                        </div>



                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">



                <div class="card px-4 mb-4">
                    <div class="card-body px-0">
                        <div class=" mb-4">
                            <h4 class="primary-title fw-bold ">Order #<span
                                    class="order_id text-danger"><?php echo e($order->order_number); ?></span>

                            </h4>
                            <div class="badge <?php echo e(badgeForOrderStatuses($order->order_status)); ?>">
                                <?php echo e(orderStatuses($order->order_status)); ?>


                            </div>
                            <?php if(in_array($order->order_status, [4, 5, 7])): ?>
                                <?php if($order->order_status == 4): ?>
                                    
                                    <span
                                        class="badge <?php echo e(\App\Helpers\CommonHelper::itemsReceivedBadges($order->orderCancel?->items_received)); ?>">
                                        <?php echo e(\App\Helpers\CommonHelper::$itemsReceivedStatus[$order->orderCancel?->items_received] ?? 'Uknown'); ?>

                                    </span>

                                    
                                    <span
                                        class="badge <?php echo e(\App\Helpers\CommonHelper::refundBadgeClass($order->orderCancel?->refund_status)); ?>">
                                        <?php echo e(\App\Helpers\CommonHelper::$refundStatuses[$order->orderCancel?->refund_status] ?? 'Uknown'); ?>

                                    </span>
                                <?php elseif($order->order_status == 5): ?>
                                    
                                    <span
                                        class="badge <?php echo e(\App\Helpers\CommonHelper::refundBadgeClass($order->orderReturn?->refund_status)); ?>">
                                        <?php echo e(\App\Helpers\CommonHelper::$refundStatuses[$order->orderReturn?->refund_status] ?? 'Unknown'); ?>

                                    </span>
                                <?php elseif($order->order_status == 7): ?>
                                    
                                    <span
                                        class="badge <?php echo e(\App\Helpers\CommonHelper::refundBadgeClass($order->refund_status)); ?>">
                                        <?php echo e(\App\Helpers\CommonHelper::$refundStatuses[$order->refund_status] ?? 'Unknown'); ?>

                                    </span>
                                <?php endif; ?>
                            <?php endif; ?>


                        </div>
                        
                        <div class="d-flex mb-0 order-total-items">
                            <h5>Total Items : </h5>
                            <h5><?php echo e($order->total_items); ?></h5>
                        </div>

                        
                        


                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-order-detail-order')): ?>
                            <?php if($order->order_status == 5): ?>
                                <div class="issueinfo">
                                    <div class="d-flex">
                                        <p class=""><b>Return Reason : </b></p>
                                        <p>&nbsp;<?php echo e($order->orderReturn->reason); ?></p>
                                    </div>
                                </div> 
                                <?php if($order->orderReturn->created_at): ?>
                                    <div class="d-flex">
                                        <p class=""><b>Return at : </b></p>

                                        <p class="text-capitalize text-danger">
                                            <b>&nbsp;&nbsp;<?php echo e(\App\Helpers\CommonHelper::formatDate($order->orderReturn->created_at, $order->customer?->timezone)); ?></b>
                                        </p>
                                        </p>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if($order->orderReturn->items_received_at): ?>
                                    <div class="d-flex">
                                        <p class=""><b>Items received at : </b></p>

                                        <p class="text-capitalize text-danger">
                                            <b>&nbsp;&nbsp;<?php echo e(\App\Helpers\CommonHelper::formatDate($order->orderReturn->items_received_at, $order->customer?->timezone)); ?></b>
                                        </p>
                                        </p>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if($order->orderReturn->refund_at): ?>
                                    <div class="d-flex">
                                        <p class=""><b>Refund at : </b></p>

                                        <p class="text-capitalize text-danger">
                                            <b>&nbsp;&nbsp;<?php echo e(\App\Helpers\CommonHelper::formatDate($order->orderReturn->refund_at, $order->customer?->timezone)); ?></b>
                                        </p>
                                        </p>
                                    </div>
                                <?php endif; ?>
                            <?php elseif($order->order_status == 4): ?>
                                <div class="issueinfo">
                                    <div class="d-flex">
                                        <p><b>Cancel Reason : </b></p>
                                        <p class="text-capitalize">&nbsp; &nbsp;<?php echo e($order->orderCancel->reason); ?></p>
                                        </p>
                                    </div>
                                    <?php if($order->orderCancel->cancel_by_type == ADMIN): ?>
                                        <div class="d-flex">
                                            <p class=""><b>Cancel By : </b></p>

                                            <p class="text-capitalize text-danger"> <b>&nbsp;&nbsp;Admin</b></p>
                                            </p>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if($order->orderCancel->created_at): ?>
                                        <div class="d-flex">
                                            <p class=""><b>Cancel at : </b></p>

                                            <p class="text-capitalize text-danger">
                                                <b>&nbsp;&nbsp;<?php echo e(\App\Helpers\CommonHelper::formatDate($order->orderCancel->created_at, $order->customer?->timezone)); ?></b>
                                            </p>
                                            </p>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if($order->orderCancel->items_received_at): ?>
                                        <div class="d-flex">
                                            <p class=""><b>Items received at : </b></p>

                                            <p class="text-capitalize text-danger">
                                                <b>&nbsp;&nbsp;<?php echo e(\App\Helpers\CommonHelper::formatDate($order->orderCancel->items_received_at, $order->customer?->timezone)); ?></b>
                                            </p>
                                            </p>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if($order->orderCancel->refund_at): ?>
                                        <div class="d-flex">
                                            <p class=""><b>Refund at : </b></p>

                                            <p class="text-capitalize text-danger">
                                                <b>&nbsp;&nbsp;<?php echo e(\App\Helpers\CommonHelper::formatDate($order->orderCancel->refund_at, $order->customer?->timezone)); ?></b>
                                            </p>
                                            </p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('status-update-order')): ?>
                            <?php if($order->order_status == 0): ?>
                                <div class="update-status-container">
                                    <div class="update-btns">
                                        
                                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.order.action-form','data' => ['url' => route('admin.orders.update', $order->id),'method' => 'put','hiddenFields' => ['order_status' => 1],'buttonText' => 'Accept the Order','buttonClass' => 'btn btn-primary','icon' => 'fas fa-check-circle','confirm' => 'update-status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('order.action-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('admin.orders.update', $order->id)),'method' => 'put','hidden-fields' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['order_status' => 1]),'button-text' => 'Accept the Order','button-class' => 'btn btn-primary','icon' => 'fas fa-check-circle','confirm' => 'update-status']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                                        
                                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.order.action-form','data' => ['url' => route('admin.orders.update', $order->id),'method' => 'put','hiddenFields' => ['order_status' => 7, 'refund_status' => 1],'buttonText' => 'Reject the Order','buttonClass' => 'btn btn-secondary','icon' => 'fas fa-times-circle','confirm' => 'update-status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('order.action-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('admin.orders.update', $order->id)),'method' => 'put','hidden-fields' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['order_status' => 7, 'refund_status' => 1]),'button-text' => 'Reject the Order','button-class' => 'btn btn-secondary','icon' => 'fas fa-times-circle','confirm' => 'update-status']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                                    </div>

                                </div>
                            <?php elseif(in_array($order->order_status, [1, 2])): ?>
                                <div class="update-status-container">
                                    <form class="row g-3 ajax-submit-form" data-confirm ="update-status"
                                        data-url="<?php echo e(route('admin.orders.update', $order->id)); ?>" data-method="post">
                                        <?php echo method_field('put'); ?>

                                        <div class="col-sm-8">

                                            <label for="order_status" class="visually-hidden">Order Status</label>
                                            <select name="order_status" class="form-select" id="order_status">
                                                <option selected value="">
                                                    <?php echo e(orderStatuses($order->order_status)); ?></option>
                                                <?php $__currentLoopData = nextOrderStatus($order->order_status); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php echo e($key == $order->order_status ? 'selected' : ''); ?>

                                                        value="<?php echo e($key); ?>">
                                                        <?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        
                                        <div class="col-sm-12 mt-2 d-none" id="cancel_reason_box">
                                            <label for="cancel_reason">Cancel Reason <span class="text-danger">*</span></label>
                                            <textarea class="form-control" name="cancel_reason" id="cancel_reason" rows="2"></textarea>
                                        </div>
                                        <div class="col-sm-4">
                                            <button type="submit" class="btn btn-primary mb-3">Update</button>
                                        </div>

                                    </form>
                                </div>


                                

                                
                            <?php elseif(in_array($order->order_status, [4]) &&
                                    $order->orderCancel->status == 0 &&
                                    $order->orderCancel->cancel_by_type == CUSTOMER): ?>
                                <div class="update-status-container">
                                    <div class="update-btns mt-2">
                                        
                                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.order.action-form','data' => ['url' => route('admin.orderCancellations.update', $order->orderCancel->id),'method' => 'put','hiddenFields' => ['status' => 1, 'refund_status' => 1],'buttonText' => 'Approve Cancel','buttonClass' => 'btn btn-primary','icon' => 'fas fa-check-circle','confirm' => 'update-status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('order.action-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('admin.orderCancellations.update', $order->orderCancel->id)),'method' => 'put','hidden-fields' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['status' => 1, 'refund_status' => 1]),'button-text' => 'Approve Cancel','button-class' => 'btn btn-primary','icon' => 'fas fa-check-circle','confirm' => 'update-status']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                                        
                                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.order.action-form','data' => ['url' => route('admin.orderCancellations.update', $order->orderCancel->id),'method' => 'put','hiddenFields' => ['status' => 2],'buttonText' => 'Reject Cancel','buttonClass' => 'btn btn-secondary','icon' => 'fas fa-times-circle','confirm' => 'update-status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('order.action-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('admin.orderCancellations.update', $order->orderCancel->id)),'method' => 'put','hidden-fields' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['status' => 2]),'button-text' => 'Reject Cancel','button-class' => 'btn btn-secondary','icon' => 'fas fa-times-circle','confirm' => 'update-status']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                                    </div>

                                </div>


                                
                            <?php elseif(in_array($order->order_status, [5]) && $order->orderReturn->status == 0): ?>
                                <div class="update-status-container">
                                    <div class="update-btns">
                                        
                                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.order.action-form','data' => ['url' => route('admin.orderReturn.update', $order->orderReturn->id),'method' => 'put','hiddenFields' => ['status' => 1, 'refund_status' => 1],'buttonText' => 'Approve Return','buttonClass' => 'btn btn-primary','icon' => 'fas fa-check-circle','confirm' => 'update-status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('order.action-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('admin.orderReturn.update', $order->orderReturn->id)),'method' => 'put','hidden-fields' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['status' => 1, 'refund_status' => 1]),'button-text' => 'Approve Return','button-class' => 'btn btn-primary','icon' => 'fas fa-check-circle','confirm' => 'update-status']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                                        
                                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.order.action-form','data' => ['url' => route('admin.orderReturn.update', $order->orderReturn->id),'method' => 'put','hiddenFields' => ['status' => 2],'buttonText' => 'Reject Return','buttonClass' => 'btn btn-secondary','icon' => 'fas fa-times-circle','confirm' => 'update-status']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('order.action-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('admin.orderReturn.update', $order->orderReturn->id)),'method' => 'put','hidden-fields' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['status' => 2]),'button-text' => 'Reject Return','button-class' => 'btn btn-secondary','icon' => 'fas fa-times-circle','confirm' => 'update-status']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                                    </div>

                                </div>
                            <?php elseif(in_array($order->order_status, [4, 5, 7])): ?>
                                
                                <?php if(
                                    ($order->orderReturn?->refund_status == 1 && !$order->orderReturn?->items_received) ||
                                        ($order->orderCancel?->refund_status == 1 && !$order->orderCancel?->items_received)): ?>
                                    <div class="update-status-container">
                                        <form class="row g-3 ajax-submit-form"
                                            data-url="<?php echo e(route('admin.ordersItemsReceived.update', $order->id)); ?>"
                                            data-method="post">
                                            <?php echo method_field('put'); ?>

                                            <input type="hidden" name="items_received" value="1">
                                            <button type="submit" class="mt-4 btn btn-primary mb-3"><i
                                                    class="fas fa-check-circle"></i>
                                                Items Received</button>

                                        </form>
                                    </div>
                                    
                                <?php elseif(
                                    ($order->orderReturn?->refund_status == 1 && $order->orderReturn?->items_received) ||
                                        ($order->orderCancel?->refund_status == 1 && $order->orderCancel?->items_received) ||
                                        ($order->order_status == 7 && $order->refund_status == 1)): ?>
                                    <div class="update-status-container">
                                        <form class="row g-3 ajax-submit-form"
                                            data-url="<?php echo e(route('admin.ordersRefund.update', $order->id)); ?>"
                                            data-method="post">
                                            <?php echo method_field('put'); ?>

                                            <input type="hidden" name="mark_as_refunded" value="2">
                                            <button type="submit" class="mt-4 btn btn-primary mb-3"><i
                                                    class="fas fa-check-circle"></i>
                                                Mark as Refunded</button>

                                        </form>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="card px-4 mb-4">
                    <div class="card-body px-0">
                        <h5 class="">Shipping Adress</h5>
                        <?php if($order->shippingAddress): ?>
                            <div class="customer-shipping-address">
                                <p class="font-weight text-capitalize"> <?php echo e($order->shippingAddress->full_name); ?></p>
                                <p><i class="fas fa-mobile-alt"></i> <?php echo e($order->shippingAddress->mobile_number); ?></p>
                                <p><i class="fas fa-map-marker-alt"></i> <?php echo e($order->shippingAddress->address); ?>,
                                    <?php echo e($order->shippingAddress->city); ?>,
                                    <?php echo e($order->shippingAddress->state); ?>,
                                    <?php echo e($order->shippingAddress->country); ?>,
                                    <?php echo e($order->shippingAddress->pincode); ?>

                                </p>



                            </div>
                        <?php else: ?>
                            <p class="font-weight text-capitalize"> Not Available</p>
                        <?php endif; ?>
                        <div class="billing">
                            <h5 class="">Billing Address</h5>


                            <div class="customer-shipping-address">
                                <?php if($order->billingAddress): ?>
                                    <p class="font-weight text-capitalize"> <?php echo e($order->billingAddress->full_name); ?></p>
                                    <p><i class="fas fa-mobile-alt"></i> <?php echo e($order->billingAddress->mobile_number); ?></p>
                                    <p><i class="fas fa-map-marker-alt"></i> <?php echo e($order->billingAddress->address); ?>,
                                        <?php echo e($order->billingAddress->city); ?>,
                                        <?php echo e($order->billingAddress->state); ?>,
                                        <?php echo e($order->billingAddress->country); ?>,
                                        <?php echo e($order->billingAddress->pincode); ?>

                                    </p>
                                <?php else: ?>
                                    <p class="font-weight text-capitalize"> Not Available</p>
                                <?php endif; ?>



                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-md-12 col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="card-body px-0">
                        <h4 class="">Order Detail</h4>
                        
                        <?php if(isset($order->orderDetails) && count($order->orderDetails) > 0): ?>
                            <table id="orderTable" class="table table-hover display responsive nowrap">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th>
                                            Product Name
                                        </th>
                                        <th>
                                            Price ( <?php echo e($order->currency_code); ?>)
                                        </th>

                                        <th>
                                            Quantity
                                        </th>
                                        <th>
                                            Total
                                        </th>

                                    </tr>
                                </thead>

                                <tbody class="table-border-bottom-0">
                                    <?php $__currentLoopData = $order->orderDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php echo e($loop->iteration); ?>

                                            </td>
                                            <td class="text-capitalize">
                                                <?php echo e($item->product_name); ?>

                                            </td>
                                            <td class="text-capitalize">
                                                <?php echo e($currencySymbol); ?>

                                                <?php echo e($item->price); ?>


                                            </td>
                                            <td class="text-capitalize">
                                                <?php echo e($item->quantity); ?>

                                            </td>
                                            <td class="text-capitalize">
                                                <?php echo e($currencySymbol); ?>

                                                <?php echo e($item->total); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>




                            </table>

                        <?php endif; ?>

                        <div class="totalpyment pt-3 d-flex justify-content-end align-items-center m-6 mb-2">
                            <div class="col-md-3 col-sm-12 order-calculations">
                                

                                
                                
                                <div class="total-cal mb-3">
                                    <h6 class=" mb-0">Products Cost:</h6>
                                    <h6 class="mb-0"><b> <?php echo e($currencySymbol); ?><?php echo e($order->subtotal); ?></b></h6>
                                </div>
                                <div class="total-cal justify-content-start mb-3">
                                    <h6 class=" mb-0">Tax:(<?php echo e($order->tax_percent); ?>%)</h6>
                                    <h6 class="mb-0"><b> <?php echo e($currencySymbol); ?><?php echo e($order->tax_amount); ?></b></h6>
                                </div>
                                <div class="total-cal justify-content-start">
                                    <h6 class=" mb-0">Total Cost:</h6>
                                    <h6 class="mb-0"><b> <?php echo e($currencySymbol); ?><?php echo e($order->total_price); ?></b></h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <!-- / Content -->
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('scripts'); ?>
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const select = document.getElementById("order_status");
                const cancelBox = document.getElementById("cancel_reason_box");
                const cancelReason = document.getElementById("cancel_reason");

                select.addEventListener("change", function() {
                    if (this.value == "4") { //cancel id
                        cancelBox.classList.remove("d-none");
                        cancelReason.setAttribute("required", "required");
                    } else {
                        cancelBox.classList.add("d-none");
                        cancelReason.removeAttribute("required");
                        cancelReason.value = "";
                    }
                });
            });
        </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\aaa\resources\views/admin/order/show.blade.php ENDPATH**/ ?>