<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="title" data-order="asc">
                    title
                    <i id="sort-icon-title" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>
            </th>

            <th>Actions</th>
        </tr>
    </thead>
    @if (isset($wholesale_id_plans) && count($wholesale_id_plans) > 0)
        <tbody class="table-border-bottom-0">

            @foreach ($wholesale_id_plans as $wholesale_id_plan)
                <tr>

                    <td class="text-capitalize">{{ $wholesale_id_plan->title }}</td>
                    <td>
                        <span class="badge {{ badgesforStatuses($wholesale_id_plan->status) }}">
                            {{ basicStatusesDisplay($wholesale_id_plan->status) }}
                        </span>

                    </td>
                    <td>{{ dateInList($wholesale_id_plan->created_at) }}</td>
                    {{-- <td><span class="badge bg-label-primary me-1">Active</span></td> --}}
                    <td class="{{ hideAction($wholesale_id_plan->status) }}">

                        @canany(['delete-wholesale_plan', 'edit-wholesale_plan'])
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    @can('edit-wholesale_plan')
                                        <a class="dropdown-item"
                                            href="{{ route('admin.wholesale-plan.edit', $wholesale_id_plan->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    @endcan
                                    @if (!$wholesale_id_plan->is_default)
                                        @can('delete-wholesale_plan')
                                            <button
                                                data-url="{{ route('admin.wholesale-plan.destroy', $wholesale_id_plan->id) }}"
                                                data-id="{{ $wholesale_id_plan->id }}" type="button"
                                                class="dropdown-item delete-btn" href="javascript:void(0);"><i
                                                    class="bx bx-trash me-1"></i>
                                                Delete</button>
                                        @endcan
                                    @endif
                                </div>
                            </div>
                        @endcanany


                    </td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records">{!! pageInfo($wholesale_id_plans) !!}</div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            {!! $wholesale_id_plans->links('pagination::bootstrap-4') !!}

                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    @endif
</table>
