@extends('admin.layouts.app')
@section('title', 'Edit Vehicle Make')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        {{-- <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Forms/</span> Horizontal Layouts</h4> --}}

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-xxl-8 col-lg-8 col-md-10 col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn ">
                        <h4 class="">Edit Vehicle Make</h4>

                    </div>
                    <div class="card-body px-0">
                        <form class="ajax-submit-form" data-url="{{ route('admin.vehicle-make.update', $vehicleMake->id) }}"
                            data-method="POST" enctype="multipart/form-data">
                            @method('PUT')

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Name</label>
                                <div class="col-sm-10">
                                    <input name="name" type="text" class="form-control " id="basic-default-name"
                                        value="{{ old('name', ucfirst($vehicleMake->name)) }}" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Image</label>
                                <div class="col-sm-10">
                                    <input type="file" name="image" class="form-control" id="">
                                    <div class="old-image">
                                        <h6 class="pt-3">Old Image</h6>
                                        <img width="100" src="{{ asset($vehicleMake->image_path) }}" alt="">
                                    </div>
                                </div>
                            </div>




                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status">Status</label>
                                <div class="col-sm-10">
                                    <select class="select2" name="status" id="status">
                                        @foreach (CommonStatusesForCrud() as $key => $value)
                                            <option value="{{ $key }}"
                                                {{ old('status', $vehicleMake->status) == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach


                                    </select>

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Vehicle Type</label>
                                <div class="col-sm-10">
                                    <div class="row" id="vehicle_types">
                                        @forelse ($vehicleTypes as $vehicleType)
                                            <div class="col-lg-3 col-md-6 col-sm-12">
                                                <div class="form-check">
                                                    <input class="form-check-input vehicle-type-checkbox" type="checkbox"
                                                        name="vehicle_types[]" value="{{ $vehicleType->id }}""
                                                        data-make-id="{{ $vehicleMake->id }}"
                                                        data-type-id="{{ $vehicleType->id }}"
                                                        id="vehicle_type_{{ $vehicleType->id }}"
                                                        {{ $vehicleMake->types->contains($vehicleType->id) ? 'checked' : '' }}>
                                                    <label class="form-check-label"
                                                        for="vehicle_type_{{ $vehicleType->id }}">
                                                        {{ ucfirst($vehicleType->name) }}
                                                    </label>
                                                </div>
                                            </div>
                                        @empty
                                        @endforelse

                                    </div>
                                </div>
                            </div>

                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
@endsection
@section('scripts')
    <script>
        $(document).on('change', '.vehicle-type-checkbox', function() {
            let isChecked = $(this).is(':checked');
            let typeId = $(this).data('type-id');
            let makeId = $(this).data('make-id');
            let checkbox = $(this);

            if (!isChecked) {
                // On uncheck: check if related vehicle models exist
                $.post('{{ route('admin.vehicleMake.checkVehicleModels') }}', {
                    _token: '{{ csrf_token() }}',
                    vehicle_make_id: makeId,
                    vehicle_type_id: typeId
                }, function(response) {
                    if (response.hasModels) {
                        Swal.fire({
                            title: "Are you sure?",
                            text: "Unchecking this will delete all related vehicle models.",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#d33",
                            cancelButtonColor: "#3085d6",
                            confirmButtonText: "Yes, delete them!"
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // Proceed with deletion
                                $.post('{{ route('admin.vehicleMake.deleteVehicleModels') }}', {
                                    _token: '{{ csrf_token() }}',
                                    vehicle_make_id: makeId,
                                    vehicle_type_id: typeId
                                }, function(res) {
                                    Swal.fire("Deleted!",
                                        "Associated vehicle models deleted.", "success");
                                });
                            } else {
                                checkbox.prop('checked', true); // Re-check it
                            }
                        });
                    }
                });
            }
        });
    </script>
@endsection
