<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                Review

            </th>
            <th>
                <span class="sortable" data-sort="full_name" data-order="asc">
                    Rating
                    <i id="sort-icon-full_name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>Status</th>
            <th>

                Product

            </th>
            <th>

                Customer


            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Submitted Date
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>
            </th>

            <th>

                Action


            </th>

        </tr>
    </thead>
    @if (isset($reviews) && count($reviews) > 0)
        <tbody class="table-border-bottom-0">

            @foreach ($reviews as $review)
                <tr>

                    <td>{{ $review->review }}</td>
                    <td>{{ $review->rating }}</td>
                    <td>
                        <span class="badge {{ \App\Helpers\CommonHelper::$badgesforStatuses[$review->status] }}">
                            {{ \App\Helpers\CommonHelper::$approvalStatuses[$review->status] }}
                        </span>

                    </td>
                    <td class="text-capitalize">{{ $review->product->name }}</td>
                    <td class="text-capitalize">{{ $review->customer?->full_name }}</td>
                    <td>{{ dateInList($review->created_at) }}</td>
                    <td>
                        @canany(['list-customer', 'delete-customer', 'edit-customer'])
                            <div class="action">
                                @can('view-review')
                                    <a class="btn btn-info" href="{{ route('admin.product.review.show', $review->id) }}">View <i
                                            class="bx bx-show me-1"></i></a>
                                @endcan
                            </div>
                        @endcanany
                    </td>
                </tr>
            @endforeach
        </tbody>

        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            {{-- <div class="" id="records">{!! pageInfo($reviews) !!}</div> --}}
                        </div>
                        <div class="col-md-6 pagination-end">

                            {{-- {!! $reviews->links('pagination::bootstrap-4') !!} --}}

                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>
    @endif
</table>
