@extends('admin.layouts.app')
@section('title', 'Edit Product')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        {{-- <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Forms/</span> Horizontal Layouts</h4> --}}

        <!-- Basic Layout & Basic with Icons -->
        <div class="row ">
            <!-- Basic Layout -->
            <div class="col-sm-12">
                <div class="card px-4 mb-4">
                    <div class="title-n-btn ">
                        <h4 class="">Edit Product</h4>

                    </div>

                    <div class="card-body px-0">
                        <form class="ajax-submit-form" data-url="{{ route('admin.product.update', $product->id) }}"
                            data-method="POST" enctype="multipart/form-data">
                            @method('PUT')

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="basic-default-name">Name</label>
                                <div class="col-sm-10">
                                    <input name="name" type="text" class="form-control" id="basic-default-name"
                                        value="{{ old('name', $product->name) }}" />

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="vehicle_model">Vehicle Models</label>

                                <div class="col-sm-10">
                                    <select class="select2 text-capitalize" name="vehicle_model[]" id="vehicle_model"
                                        multiple="multiple">
                                        @foreach ($vehicleModels as $vehicleModel)
                                            <option class="text-capitalize" value="{{ $vehicleModel->id }}"
                                                {{ in_array($vehicleModel->id, $product->compatibleModels->pluck('id')->toArray()) ? 'selected' : '' }}>
                                                Type: {{ $vehicleModel->vehicleType->name ?? 'N/A' }}
                                                &nbsp;&nbsp;>>&nbsp;&nbsp;
                                                Make: {{ $vehicleModel->vehicleMake->name ?? 'N/A' }}
                                                &nbsp;&nbsp;>>&nbsp;&nbsp;
                                                Model: {{ $vehicleModel->name }}
                                            </option>
                                        @endforeach


                                    </select>


                                </div>
                            </div>
                            {{-- <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="price">Price</label>
                                <div class="col-sm-10">
                                    <input name="price" type="number" step="0.01" min="0" class="form-control"
                                        id="price" value="{{ old('price', $product->price) }}" />
                                </div>
                            </div> --}}
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="price">Price</label>
                                <div class="col-sm-3">
                                    {{-- <input name="price" type="number" step="0.01" min="0" class="form-control"
                                        id="price" /> --}}
                                    <div class="input-group">
                                        <span class="input-group-text" id="basic-addon13">USD</span>
                                        <input type="number" step="0.01" min="0" name="price_in_usd"
                                            id="price_in_usd" class="form-control" placeholder="" aria-label="price_in_usd"
                                            aria-describedby="basic-addon13"
                                            value="{{ old('price_in_usd', $product->price_in_usd) }}" />

                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <span class="input-group-text" id="basic-addon13">MMK</span>
                                        <input type="number" step="0.01" min="0" name="price_in_mmk"
                                            id="price_in_mmk" class="form-control" placeholder="" aria-label="price_in_mmk"
                                            aria-describedby="basic-addon13"
                                            value="{{ old('price_in_mmk', $product->price_in_mmk) }}" />

                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <span class="input-group-text" id="basic-addon13">RMB</span>
                                        <input type="number" step="0.01" min="0" name="price_in_rmb"
                                            id="price_in_rmb" class="form-control" placeholder="" aria-label="price_in_rmb"
                                            aria-describedby="basic-addon13"
                                            value="{{ old('price_in_rmb', $product->price_in_rmb) }}" />

                                    </div>
                                </div>

                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="images">Inventory</label>
                                <div class="col-sm-10">
                                    <div class="d-flex">
                                        <p class="padding-right-10">{{ $product->stock_in_hand }}</p>
                                        <a class="text-link"
                                            href="{{ route('admin.product.manageInventory', $product->id) }}">Manage
                                            Inventory</a>
                                    </div>


                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="images">Featured Image</label>
                                <div class="col-sm-10">
                                    {{-- <input class="form-control" type="file" id="formFileMultiple" multiple /> --}}
                                    <input type="file" name="feature_image" class="form-control" id="feature_image">
                                    @if ($product->featuredImage)
                                        <div class="old-image">
                                            <h6 class="pt-3">Current Featured Image</h6>
                                            <div class="row">


                                                <div class="col-lg-3 col-md-6 col-sm-12 pb-3">

                                                    <img width="200" src="{{ asset($product->featuredImage->image) }}"
                                                        alt="" class="h-200 ">


                                                </div>


                                            </div>


                                        </div>
                                    @endif

                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="description">Description</label>
                                <div class="col-sm-10">
                                    <textarea name="description" id="description" class="form-control " cols="30" rows="10"> {{ old('description', $product->description) }}</textarea>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="status">Status</label>
                                <div class="col-sm-10">
                                    <select class="select2" name="status" id="status">
                                        @foreach (CommonStatusesForCrud() as $key => $value)
                                            <option {{ old('status', $product->status) == $key ? 'selected' : '' }}
                                                value="{{ $key }}">{{ $value }}</option>
                                        @endforeach


                                    </select>

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label" for="images">Gallery</label>
                                <div class="col-sm-10">
                                    {{-- <input class="form-control" type="file" id="formFileMultiple" multiple /> --}}
                                    <input type="file" name="images[]" class="form-control" id="images" multiple>
                                    <div class="old-image">
                                        <h6 class="pt-3">Current Image(s)</h6>
                                        <div class="row">

                                            @foreach ($product->images as $image)
                                                <div class="col-lg-3 col-md-6 col-sm-12 py-3">
                                                    <div class="image-container position-relative image-wrapper"
                                                        data-id="{{ $image->id }}">
                                                        <img width="200" src="{{ asset($image->image) }}"
                                                            alt="" class="h-200 ">
                                                        <button type="button"
                                                            class="btn btn-danger btn-sm position-absolute delete-image"
                                                            data-id="{{ $image->id }}"
                                                            data-url="{{ route('admin.product.image.delete', $image->id) }}">&times;</button>
                                                    </div>
                                                </div>
                                            @endforeach

                                        </div>


                                    </div>
                                </div>
                            </div>

                            <div class="row justify-content-end">
                                <div class="col-sm-10">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox"
                                            {{ old('is_featured', $product->is_featured ?? false) ? 'checked' : '' }}
                                            value="" id="is_featured" name="is_featured">
                                        <label class="form-check-label" for="is_featured">
                                            Set as Featured Product
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="row justify-content-end pt-3">
                                <div class="col-sm-10">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- / Content -->
@endsection
@section('scripts')
    <script>
        $(document).on('click', '.delete-image', function() {
            let imageId = $(this).data('id');
            let url = $(this).data('url');
            let button = $(this);

            Swal.fire({
                title: 'Are you sure?',
                text: "You want to delete this image?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: url,
                        type: 'DELETE',

                        success: function(res) {
                            button.closest('.image-container').remove();
                            Swal.fire({
                                title: 'Deleted!',
                                text: 'Image has been deleted.',
                                icon: 'success'
                            }).then((result) => {

                                // if (result.isConfirmed || result.isDismissed) {
                                //     location
                                //         .reload();
                                // }
                            });
                        },
                        error: function() {
                            Swal.fire('Error!', 'Something went wrong.', 'error');
                        }
                    });
                }
            });
        });


        const usdToMmkRate = {{ $currrncyRateMmk ?? 0 }}
        const usdToRmbRate = {{ $currrncyRateRmb ?? 0 }}
        // When typing in USD field
        $('#price_in_usd').on('input', function() {
            let usd = parseFloat($(this).val());
            if (!isNaN(usd)) {
                let mmk = (usd * usdToMmkRate).toFixed(2);
                let rmb = (usd * usdToRmbRate).toFixed(2);
                $('#price_in_mmk').val(mmk);
                $('#price_in_rmb').val(rmb);
            } else {
                $('#price_in_mmk').val('');
                $('#price_in_rmb').val('');
            }
        });

        // When typing in MMK field
        $('#price_in_mmk').on('input', function() {
            let mmk = parseFloat($(this).val());
            if (!isNaN(mmk)) {

                let usd = (mmk / usdToMmkRate).toFixed(2);
                $('#price_in_usd').val(usd);
                let rmb = (usd * usdToRmbRate).toFixed(2);

                $('#price_in_rmb').val(rmb);
            } else {
                $('#price_in_usd').val('');
                $('#price_in_rmb').val('');
            }
        });
        // When typing in RMB field
        $('#price_in_rmb').on('input', function() {
            let rmb = parseFloat($(this).val());
            let mmk = parseFloat($('#price_in_mmk').val());
            if (!isNaN(rmb)) {
                let usd = (rmb / usdToRmbRate).toFixed(2);
                $('#price_in_usd').val(usd);
                let mmk = (usd * usdToMmkRate).toFixed(2);
                $('#price_in_mmk').val(mmk);
            } else {
                $('#price_in_usd').val('');
                $('#price_in_mmk').val('');

            }
        });
    </script>
@endsection
