@extends('admin.layouts.app')
@section('title', 'Order Detail')
@section('content')
    <!-- Content -->
    <div class="container">
        <div class="row mt-3">
            <div class="col-lg-4 col-sm-6">
                <div class="order-detail-wrapper">
                    <h5>Customer Detail</h5>
                    <div class="order-detail-user-info">
                        <div class="order-detail-user-img">
                            <img src="{{ asset('assets/img/default.png') }}" class="img-fluid">
                        </div>
                        <div class="order-detail-user-text">
                            <h4>Prof. Dedric Dietrich</h4>
                            <p><b>Email:</b> brice76@example.net</p>
                            <p><b>Phone Number:</b> 944234418</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="order-detail-wrapper">
                    <div class="order-list-view">
                        <h5>Order#:<span class="order-number"> ORD681DED4730A6A</span> <span
                                class="badge bg-secondary">Returned</span></h5>
                        <h4>Total: 5 Items</h4>

                    </div>
                    <div class="return-reason">
                        <h4>Return Reason :<br> <span>Defective items received</span></h4>
                        <button class="btn btn-danger">Mark as Refunded</button>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="order-detail-wrapper">
                    <div class="shipping-list-view">
                        <h4>Shipping Address</h4>
                        <p>33379 Amely Greens Parismouth, MO 42575 Jabariton, Georgia Myanmar, 20876-1230</p>
                        <h4>Billing Address</h4>
                        <p>79938 Doyle Prairie Suite 277 Codybury, WA 15802 Magaliburgh, Montana Myanmar, 38305</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-sm-12 mt-3">
                <div class="shipping-activity">
                    wdqwdqwd
                </div>
            </div>
            <div class="col-lg-12 col-sm-12 mt-3">
                <div class="shipping-table">
                    <h4>Order Details</h4>
                    @if (isset($order->orderDetails) && count($order->orderDetails) > 0)
                        <table id="myTable" class="dataTable table table-hover display responsive nowrap">
                            <thead>
                                <tr>
                                    <th>
                                        Product Name
                                    </th>
                                    <th style="width: 50px;">
                                        Price
                                    </th>

                                    <th>
                                        Quantity
                                    </th>
                                    <th>
                                        Total
                                    </th>

                                </tr>
                            </thead>

                            <tbody class="table-border-bottom-0">
                                @foreach ($order->orderDetails as $item)
                                    <tr>
                                        <td class="text-capitalize">
                                            {{ $item->product_name }}
                                        </td>
                                        <td class="text-capitalize">
                                            {{ $item->price }}
                                        </td>
                                        <td class="text-capitalize">
                                            {{ $item->quantity }}
                                        </td>
                                        <td class="text-capitalize">
                                            {{ $item->total }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>




                        </table>

                    @endif
                    <div class="col-lg-12 col-sm-12">
                        <div class="billing-details">
                            <table class="table table-bordered">
                                <tbody>
                                    <tr>
                                        <td>Total(USD): </td>
                                        <td><strong>2398.00</strong></td>
                                    </tr>
                                    <tr>
                                        <td>Total(MMK):</td>
                                        <td><strong>4316400.00</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-lg-12 col-sm-12 mt-3">
                <div class="shipping-activity">
                    wdqwdqwd
                </div>
            </div>

        </div>
    </div>
    <!-- / Content -->
@endsection
