@extends('admin.layouts.app')
@section('title', 'Welcome to AAA Admin Dashboard')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        @canany(['list-vehicle_type', 'list-vehicle_make', 'list-vehicle_model', 'list-product', 'list-customer',
            'list-order'])
            <div class="row">

                @can('list-vehicle_type')
                    <div class="col-lg-3 col-md-3 col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class=" dashboard-icon flex-shrink-0">
                                        <img src="{{ asset('assets/img/car.png') }}" alt="chart success" class="rounded" />
                                    </div>

                                </div>

                                <h3 class="card-title mb-2">Vehicle Types</h3>
                                <h5 class="fw-semibold d-block mb-1 ">{{ $vehicleTypesCount }}</h5>
                                <a class="pt-3" href="{{ route('admin.vehicle-type.index') }}">View More</a>
                            </div>
                        </div>
                    </div>
                @endcan
                @can('list-vehicle_make')
                    <div class="col-lg-3 col-md-3 col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class=" dashboard-icon flex-shrink-0">
                                        <img src="{{ asset('assets/img/reputation.png') }}" alt="chart success" class="rounded" />
                                    </div>

                                </div>

                                <h3 class="card-title mb-2">Vehicle Makes</h3>
                                <h5 class="fw-semibold d-block mb-1 ">{{ $vehicleMakesCount }}</h5>
                                <a class="pt-3" href="{{ route('admin.vehicle-make.index') }}">View More</a>
                            </div>
                        </div>
                    </div>
                @endcan
                @can('list-vehicle_model')
                    <div class="col-lg-3 col-md-3 col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class=" dashboard-icon flex-shrink-0">
                                        <img src="{{ asset('assets/img/data-modelling.png') }}" alt="chart success"
                                            class="rounded" />
                                    </div>

                                </div>

                                <h3 class="card-title mb-2">Vehicle Models</h3>
                                <h5 class="fw-semibold d-block mb-1 ">{{ $vehicleModelsCount }}</h5>
                                <a class="pt-3" href="{{ route('admin.vehicle-model.index') }}">View More</a>
                            </div>
                        </div>
                    </div>
                @endcan
                @can('list-product')
                    <div class="col-lg-3 col-md-3 col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class=" dashboard-icon flex-shrink-0">
                                        <img src="{{ asset('assets/img/best-product.png') }}" alt="chart success" class="rounded" />
                                    </div>

                                </div>

                                <h3 class="card-title mb-2">Products</h3>
                                <h5 class="fw-semibold d-block mb-1 ">{{ $productsCount }}</h5>
                                <a class="pt-3" href="{{ route('admin.product.index') }}">View More</a>
                            </div>
                        </div>
                    </div>
                @endcan
                @can('list-customer')
                    <div class="col-lg-3 col-md-3 col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class=" dashboard-icon flex-shrink-0">
                                        <img src="{{ asset('assets/img/customer.png') }}" alt="chart success" class="rounded" />
                                    </div>

                                </div>

                                <h3 class="card-title mb-2">Customers</h3>
                                <h5 class="fw-semibold d-block mb-1 ">{{ $customerCount }}</h5>
                                <a class="pt-3" href="{{ route('admin.customer.index') }}">View More</a>
                            </div>
                        </div>
                    </div>
                @endcan
                @can('list-order')
                    <div class="col-lg-3 col-md-3 col-6 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-title d-flex align-items-start justify-content-between">
                                    <div class=" dashboard-icon flex-shrink-0">
                                        <img src="{{ asset('assets/img/cargo.png') }}" alt="chart success" class="rounded" />
                                    </div>

                                </div>

                                <h3 class="card-title mb-2">Orders</h3>
                                <h5 class="fw-semibold d-block mb-1 ">{{ $ordersCount }}</h5>
                                <a class="pt-3" href="{{ route('admin.orders.index') }}">View More</a>
                            </div>
                        </div>
                    </div>
                @endcan

                <!-- Total Revenue -->

            </div>
        @else
            <div class="row">
                <div class="col-12">
                    <div class="row ">
                        <div class="col-lg-6 col-md-12 col-6 mb-4">
                            <div class="card">
                                <div class="card-body">


                                    <h3 class="card-title mb-2">
                                        No content for you

                                    </h3>
                                    {{-- <small class="text-success fw-semibold"><i class="bx bx-up-arrow-alt"></i>
                                        +72.80%</small> --}}
                                </div>
                            </div>
                        </div>


                    </div>
                </div>

            </div>
        @endcanany

    </div>
    <!-- / Content -->

@endsection
