<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="full_name" data-order="asc">
                    Name
                    <i id="sort-icon-full_name" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="email" data-order="asc">
                    Email
                    <i id="sort-icon-email" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="mobile_number" data-order="asc">
                    Mobile
                    <i id="sort-icon-mobile_number" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="wholesale_plan_id" data-order="asc">
                    Wholesale ID
                    {{-- <i id="sort-icon-wholesale_plan_id" class="bx bx-sort"></i> --}}
                </span>
            </th>

            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    @if (isset($customers) && count($customers) > 0)
        <tbody class="table-border-bottom-0">

            @foreach ($customers as $customer)
                <tr>

                    <td class="text-capitalize">{{ $customer->full_name }}</td>
                    <td>{{ $customer->email }}</td>
                    <td>{{ $customer->dial_code }}{{ $customer->mobile_number }}</td>
                    <td>
                        <div>
                            <span class="{{ $customer->activePlanWholesale ? 'text-success' : 'text-danger' }}">
                                {{ $customer->activePlanWholesale ? 'Yes' : 'N/A' }}
                            </span>

                        </div>
                        {{ $customer->activePlanWholesale ? $customer->activePlanWholesale->custom_plan_id : '' }}
                    </td>
                    <td>
                        <span class="badge {{ badgesforStatuses($customer->status) }}">
                            {{ basicStatusesDisplay($customer->status) }}
                        </span>
                    </td>
                    <td>{{ dateInList($customer->created_at) }}</td>
                    {{-- <td><span class="badge bg-label-primary me-1">Active</span></td> --}}
                    <td class="{{ hideAction($customer->status) }}">
                        @canany(['list-customer', 'delete-customer', 'edit-customer'])
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    @can(['list-customer'])
                                        <a class="dropdown-item"
                                            href="{{ url('admin/orders?customer_id=' . $customer->id) }}"><i
                                                class="bx bx-show me-1"></i> View Orders</a>
                                    @endcan
                                    @can('edit-customer')
                                        <a class="dropdown-item" href="{{ route('admin.customer.edit', $customer->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    @endcan
                                    @can('delete-customer')
                                        <button data-url="{{ route('admin.customer.destroy', $customer->id) }}"
                                            data-id="{{ $customer->id }}" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    @endcan
                                </div>
                            </div>
                        @endcanany
                    </td>
                </tr>
            @endforeach
        </tbody>

        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records">{!! pageInfo($customers) !!}</div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            {!! $customers->links('pagination::bootstrap-4') !!}

                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>
    @endif
</table>
