@extends('admin.layouts.app')
@section('title', 'Welcome to AAA Admin Dashboard')
@section('content')
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <section>
            <div class="container py-5">

                <div class="row">

                    <div class="chat-sidebar col-md-6 col-lg-5 col-xl-4 mb-4 mb-md-0 ">

                        <h5 class="font-weight-bold mb-3 text-center text-lg-start">Conversation</h5>

                        <div class="card">
                            <div class="card-body">
                                <ul class="list-unstyled mb-0">
                                    @forelse ($conversations as $conversation)
                                        <li class="p-2 border-bottom bg-body-tertiary conversation-item"
                                            data-id="{{ $conversation->id }}">
                                            <a href="#" class="d-flex justify-content-between">
                                                <div class="d-flex flex-row">
                                                    @if ($conversation->customer->image)
                                                        <img src="{{ asset($conversation->customer->image) }}"
                                                            alt="avatar"
                                                            class="rounded-circle d-flex align-self-center me-3 shadow-1-strong"
                                                            width="60">
                                                    @else
                                                        <img src="{{ asset(DEFAULT_PATH) }}" alt="avatar"
                                                            class="rounded-circle d-flex align-self-center me-3 shadow-1-strong"
                                                            width="60">
                                                    @endif

                                                    <div class="pt-1">
                                                        <p class="fw-bold mb-0"> {{ $conversation->customer->full_name }}
                                                        </p>
                                                        <p class="small text-muted">
                                                            {{ $conversation->lastMessage?->message }}</p>

                                                    </div>
                                                </div>
                                                <div class="pt-1">
                                                    <p class="small text-muted mb-1">Just now</p>
                                                    @if (!$conversation->lastMessage?->is_read)
                                                        <span class="badge bg-danger float-end">1</span>
                                                    @endif

                                                </div>
                                            </a>
                                        </li>
                                    @empty
                                        <li>
                                            <p class="text-mute">No Conversation available yet!</p>
                                        </li>
                                    @endforelse
                                </ul>
                            </div>
                        </div>

                    </div>
                    {{-- show messages --}}
                    <div class=" col-md-6 col-lg-7 col-xl-8">
                        <div class="chat-messages">
                            <ul class="list-unstyled" id="messages-list">
                                {{-- <li class="d-flex justify-content-between mb-4 customer-message">
                                <img src="https://mdbcdn.b-cdn.net/img/Photos/Avatars/avatar-6.webp" alt="avatar"
                                    class="rounded-circle d-flex align-self-start me-3 shadow-1-strong" width="60">
                                <div class="card">
                                    <div class="card-header d-flex justify-content-between p-3">
                                        <p class="fw-bold mb-0">Brad Pitt</p>
                                        <p class="text-muted small mb-0"><i class="far fa-clock"></i> 12 mins ago</p>
                                    </div>
                                    <div class="card-body">
                                        <p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
                                            incididunt ut
                                            labore et dolore magna aliqua.
                                        </p>
                                    </div>
                                </div>
                            </li>
                            <li class="d-flex justify-content-between mb-4 admin-message">
                                <div class="card w-100">
                                    <div class="card-header d-flex justify-content-between p-3">
                                        <p class="fw-bold mb-0">Lara Croft</p>
                                        <p class="text-muted small mb-0"><i class="far fa-clock"></i> 13 mins ago</p>
                                    </div>
                                    <div class="card-body">
                                        <p class="mb-0">
                                            Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium
                                            doloremque
                                            laudantium.
                                        </p>
                                    </div>
                                </div>
                                <img src="https://mdbcdn.b-cdn.net/img/Photos/Avatars/avatar-5.webp" alt="avatar"
                                    class="rounded-circle d-flex align-self-start ms-3 shadow-1-strong" width="60">
                            </li> --}}


                            </ul>
                        </div>
                        <ul class="list-unstyled">
                            <li class="bg-white mb-3">
                                <div data-mdb-input-init class="form-outline">
                                    <textarea class="form-control bg-body-tertiary" id="message-input" rows="4"></textarea>
                                    <label class="form-label" for="textAreaExample2">Message</label>
                                </div>
                            </li>
                            <button type="button" id="send-btn" data-mdb-button-init data-mdb-ripple-init
                                class="btn btn-info btn-rounded float-end">Send</button>
                        </ul>

                    </div>

                </div>

            </div>
        </section>

    </div>
    <!-- / Content -->

@endsection
@section('scripts')
    <script>
        let convo_id = {{ $conversation->id }}
    </script>
@endsection
