<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>


            <th class="sortable" data-sort="sort_order" data-order="asc">

                Order No.


            </th>
            <th>

                Image/Video


            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>

            </th>
            <th>Actions</th>
        </tr>
    </thead>
    @if (isset($banners) && count($banners) > 0)
        <tbody class="table-border-bottom-0">

            @foreach ($banners as $banner)
                <tr>

                    <td class="text-capitalize">{{ $banner->sort_order }}</td>
                    <td class="text-capitalize">


                        @if ($banner->media_type == IMAGE)
                            <a data-type="image" data-fancybox="gallery" href="{{ asset($banner->media_path) }}">
                                <img class="media-item" src="{{ asset($banner->media_path) }}" width="80px" />
                            </a>
                        @elseif($banner->media_type == VIDEO)
                            <a data-fancybox="gallery" href="{{ asset($banner->media_path) }}">
                                <img class="media-item" src="{{ asset($banner->video_poster) }}" width="80px" />
                            </a>
                        @else
                            <span class="text-muted">No media</span>
                        @endif
                    </td>


                    <td>
                        <span class="badge {{ badgesforStatuses($banner->status) }}">
                            {{ basicStatusesDisplay($banner->status) }}
                        </span>

                    </td>
                    <td>{{ dateInList($banner->created_at) }}</td>
                    <td>
                        @canany(['list-employee', 'edit-employee', 'delete-employee'])
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    @can('edit-banner')
                                        <a class="dropdown-item" href="{{ route('admin.banner.edit', $banner->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    @endcan
                                    @can('delete-banner')
                                        <button data-url="{{ route('admin.banner.destroy', $banner->id) }}"
                                            data-id="{{ $banner->id }}" type="button" class="dropdown-item delete-btn"
                                            href="javascript:void(0);"><i class="bx bx-trash me-1"></i>
                                            Delete</button>
                                    @endcan
                                </div>
                            </div>
                        @endcanany
                    </td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="5">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records">{!! pageInfo($banners) !!}</div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            {!! $banners->links('pagination::bootstrap-4') !!}

                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    @endif
</table>
