<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Faker\Factory;
use Illuminate\Support\Facades\DB;

class AddressSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faker = Factory::create();
        foreach (range(3, 103) as $orderId) {
            $billingAddress = [
                'order_id' => $orderId,
                'full_name' => $faker->name,
                'mobile_number' => $faker->numerify('##########'),
                'address' => $faker->address,
                'state' => $faker->state,
                'city' => $faker->city,
                'pincode' => $faker->postcode,
                'created_at' => now(),
                'updated_at' => now()
            ];
            $shippingAddress = [
                'order_id' => $orderId,
                'full_name' => $faker->name,
                'mobile_number' => $faker->numerify('##########'),
                'address' => $faker->address,
                'state' => $faker->state,
                'city' => $faker->city,
                'pincode' => $faker->postcode,
                'created_at' => now(),
                'updated_at' => now()
            ];
            DB::table('shipping_addresses')->insert($shippingAddress);
            DB::table('billing_addresses')->insert($billingAddress);
        }
    }
}
