<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Customer>
 */
class CustomerFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'full_name' => $this->faker->name(),
            'email' => $this->faker->unique()->safeEmail,
            'address' => $this->faker->address(),
            'password' => Hash::make('123456'),
            'dial_code' => '+95',
            'dial_code_iso' => 'MM',
            'mobile_number' => $this->faker->numerify('9########'),
            'status' => $this->faker->randomElement([0, 1, 2]),
            'description' => $this->faker->sentence(),

        ];
    }
}
