<?php

namespace App\Providers;

use App\Helpers\CommonHelper;
use App\Models\Notification;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Blade::if('canViewOrderDetail', function ($order) {
            return CommonHelper::canViewOrderDetail(auth()->user(), $order);
        });

        // Share notifications with the main layout
        View::composer('*', function ($view) {
            $unreadCount = Notification::where('receiver_type', 'ADMIN')
                ->where('is_read', 0)
                ->count();
            $notifications = Notification::where('receiver_type', 'ADMIN')
                ->orderBy('created_at', 'desc')
                ->take(5)
                ->get();
            //json decode
            $notifications->transform(function ($notification) {
                $notification->data = json_decode($notification->data, true);
                return $notification;
            });


            //message notification
            $messageNotifications = Notification::where('type', CHAT)
                ->where('receiver_type', ADMIN)
                ->orderBy('created_at', 'desc')
                ->take(5)
                ->get();
            //get json data encode
            $messageNotifications->transform(function ($message) {
                $message->data = json_decode($message->data, true);
                return $message;
            });
            //message count
            $UnreadCountMessage = Notification::where('type', CHAT)
                ->where('receiver_type', ADMIN)
                ->where('is_read', 0)
                ->count();
            $view->with(compact('unreadCount', 'notifications', 'messageNotifications', 'UnreadCountMessage'));
        });
    }
}
