<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WholesaleIdPlan extends Model
{
    use SoftDeletes;
    use HasFactory;
    protected $table = 'wholesale_id_plans';
    protected $fillable = [
        'title',
        'price_in_usd',
        'price_in_mmk',
        'price_in_rmb',
        'min_order_amt_usd',
        'min_order_amt_mmk',
        'min_order_amt_rmb',
        'discount',
        'is_default',
        'status'
    ];

    public function customerAssignments()
    {
        return $this->hasMany(CustomerWholesalePlan::class, 'original_plan_id');
    }
    public static function getPaginatedData($request)
    {
        $query = self::whereIn('status', [0, 1]);

        $perPage = $request->input('per_page', 10);
        $sortBy = $request->get('sort_by');
        $allowedSortColumns = ['id', 'title', 'status', 'created_at']; // add only valid DB columns here

        // Default to 'wholesale_id_plans.id' if invalid or empty
        $sortBy = in_array($sortBy, $allowedSortColumns) ? 'wholesale_id_plans.' . $sortBy : 'wholesale_id_plans.id';

        $sortOrder = $request->get('sort_order', 'desc');
        $sortOrder = in_array(strtolower($sortOrder), ['asc', 'desc']) ? $sortOrder : 'desc';

        if ($request->filled('keyword')) {
            $keyword = $request->keyword;
            $query->where(function ($q) use ($keyword) {
                $q->where('title', 'like', "%$keyword%")
                    ->orWhere('status', 'like', "%$keyword%")
                    ->orWhere('id', 'like', "%$keyword%");
            });
        }

        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }

        return $query->orderBy($sortBy, $sortOrder)->paginate($perPage);
    }
}
