<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerWholesalePlan extends Model
{
    use HasFactory;
    protected $table = 'customer_wholesale_plans';
    protected $fillable = [
        'customer_id',
        'original_plan_id',
        'custom_plan_id',
        'title',
        'price_in_usd',
        'price_in_mmk',
        'price_in_rmb',
        'discount',
        'number_of_days',
        'min_order_amt_usd',
        'min_order_amt_mmk',
        'min_order_amt_rmb',
        'start_date',
        'end_date',
        'status',
        'cashback_from_date',
        'cashback_to_date'
    ];
    public function customers()
    {
        return $this->belongsTo(Customer::class);
    }
    public function originPaln()
    {
        return $this->belongsTo(WholesaleIdPlan::class, 'original_plan_id');
    }
}
