<?php

namespace App\Models;

use App\Helpers\CommonHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Validator;

class Banner extends Model
{
    use HasFactory;
    protected $fillable = [
        'media_path',
        'media_type',
        'media_extension',
        'status',
        'sort_order',
        'video_poster'
    ];
    protected $table = 'banners';
    public static function pagination($request)
    {

        $query = self::query();

        $perPage = $request->input('per_page', 10);
        $sortBy = $request->get('sort_by');
        $allowedSortColumns = ['id', 'sort_order', 'status', 'created_at']; // add only valid DB columns here

        // Default to 'banners.id' if invalid or empty
        $sortBy = in_array($sortBy, $allowedSortColumns) ? 'banners.' . $sortBy : 'banners.id';

        $sortOrder = $request->get('sort_order', 'asc');
        $sortOrder = in_array(strtolower($sortOrder), ['asc', 'desc']) ? $sortOrder : 'desc';



        if ($request->filled('status')) {
            $query->where('status', $request->status);
        }



        return $query->orderBy($sortBy, $sortOrder)->paginate($perPage);
    }
    public static function validation($inputs = [], $id = null)

    {
        $videosExtensions = CommonHelper::allowedVideoExtension();
        $imageExtensions = CommonHelper::allowedImageExtension();
        $allowedExtensions = array_merge($videosExtensions, $imageExtensions);
        $mimesRules = implode(',', $allowedExtensions);
        $rules = [
            'file' => 'required|mimes:' . $mimesRules . '|max:10240', //10mb
            'status' => 'required|in:0,1',
            'sort_order' => 'required|integer'
        ];
        if ($id) {
            $rules['file'] = 'nullable|mimes:' . $mimesRules . '|max:10240'; //10mb
        }
        return Validator($inputs, $rules);
    }
}
