<?php

namespace App\Http\Controllers;

use App\Helpers\CommonHelper;
use App\Models\CustomerWholesalePlan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Throwable;

class CronController extends Controller
{
    public function checkWholesalePlan()
    {
        DB::beginTransaction();
        try {

            $plans = CustomerWholesalePlan::where('status', 'active')->whereDate('end_date', '<', now())->get();

            foreach ($plans as $plan) { {
                    $plan->status = 'expired';
                    $plan->save();
                }
            }
            DB::commit();
        } catch (Throwable $e) {
            DB::rollBack();
            return CommonHelper::jsonErrorResponseWeb($e);
        }
    }
}
