<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\CommonHelper;
use App\Http\Controllers\Controller;
use App\Models\Conversation;
use App\Models\Message;
use App\Models\Notification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ChatContoller extends Controller
{
    //submit conversation
    public function sendMessage(Request $request, $conversationId)
    {
        $conversation = Conversation::findOrFail($conversationId);
        $validation = Validator::make($request->all(), [
            'message' => 'required|string'
        ]);
        if ($validation->fails()) {
            return CommonHelper::jsonResponseWeb(400, '', $validation->errors());
        }
        $message = new Message();
        $message->conversation_id = $conversation->id;
        $message->sender_id = auth()->id();
        $message->sender_type = \App\Models\User::class;
        $message->message = $request->message;
        $message->save();
        return response()->json([
            'success' => true,
            'message' => $message->load('sender')
        ]);
    }
    //fetch conversation
    public function fetchConversation()
    {
        //set that particular notification of message to 1
        Notification::where('type', CHAT)
            ->where('receiver_id', auth()->id())
            ->where('receiver_type', ADMIN)
            ->where('is_read', 0)
            ->update(['is_read' => 1]);
        $conversations = Conversation::with(['customer', 'lastMessage'])
            ->where('status', 'open')
            ->orderBy('created_at', 'desc')
            ->get();
        return view('admin.chat.index', compact('conversations'));
    }
    //show messages
    public function showMessages($conversationId)
    {


        $messages = Message::with(['sender'])
            ->where('conversation_id', $conversationId)
            ->orderBy('created_at', 'asc')
            ->get();
        return response()->json($messages);
    }
}
