<?php

use Carbon\Carbon;
use  App\Helpers\CommonHelper;
use Illuminate\Support\Collection;

define('DEFAULT_PATH', 'uploads/default.png');
define('MAKE_PATH', 'uploads/admin/makes');
define('PRODUCT_PATH', 'uploads/admin/products');
define('CUSTOMER_PATH', 'uploads/admin/customers');
define('EMPLOYEE_IMAGE_PATH', 'uploads/admin');
define('BANNER_FILE_PATH', 'uploads/banners');
define('REVIEW_FILE_PATH', 'uploads/reviews');
define('MESSAGE_MEDIA', 'uploads/messages-media');
define('FINANCE', 'finance');
define('SUPER_ADMIN', 'Super Admin');
define('ACTIVE', 'active');
define('DEACTIVE', 'deactive');
define('EXPIRED', 'expired');
define('SCHEDULED', 'scheduled');
define('CANCELLED', 'cancelled');
define('ORDER_CANCEL', 'order_cancel');
define('ORDER_RETURN', 'order_return');
define('ORDER_REJECT', 'order_reject');
define('IMAGE', 'image');
define('VIDEO', 'video');
define('CNY', 'CNY');
define('RMB', 'RMB');
define('MMK', 'MMK');
define('USD', 'USD');
define('ACTION_RETURN', 'return');
define('ACTION_CANCEL', 'cancel');
define('ADMIN', 'admin');
define('CUSTOMER', 'customer');
//notification types
define('ORDER_PLACED', 'order_placed');
define('ORDER_CONFIRMED', 'order_confirmed');
define('ORDER_SHIPPED', 'order_shipped');
define('ORDER_DELIVERED', 'order_delivered');
define('ORDER_CANCELLED', 'order_cancelled');
define('ORDER_REJECTED', 'order_rejected');
define('ORDER_RETURNED', 'order_returned');
define('ORDER_REFUND', 'order_refund');
define('ORDER_RETURN_APPROVED', 'order_return_approved');
define('ORDER_RETURN_REJECTED', 'order_return_rejected');
define('ORDER_CANCEL_APPROVED', 'order_cancel_approved');
define('ORDER_CANCEL_REJECTED', 'order_cancel_rejected');
define('REVIEW_SUBMITTED', 'review_submitted');
define('REVIEW_UPDATED', 'review_updated');
define('CHAT', 'chat');







function CommonStatuses()
{
    return [
        1 => 'Active',
        0 => 'Inactive',
        //2 => 'Deleted'
    ];
}
function CommonStatusesForCrud()
{
    return [
        1 => 'Active',
        0 => 'Inactive',

    ];
}
function dateInList($date, $format = 'd-m-Y')
{
    return Carbon::parse($date)->format($format);
}
// function basicSatusesDisplay($status)
// {
//     $statuses =  [
//         0 => 'Inactive',
//         1 => 'Active'
//     ];
//     return $statuses[$status];
// }
function basicStatusesDisplay($status)
{
    return CommonHelper::basicStatusesDisplay($status);
}
function badgesforStatuses($status)
{
    return CommonHelper::badgesforStatuses($status);
}
//per page drop down
function perPage()
{
    return [
        10 => 10,
        20 => 20,
        50 => 50,
        100 => 100,
        500 => 500
    ];
}
function pageInfo($pagination)
{
    $from = ((($pagination->currentPage() - 1) * $pagination->perPage()) + 1);
    $to = (($pagination->currentPage()) * $pagination->perPage());
    $total = $pagination->total();
    if ($to > $total) {
        $to = $pagination->total();
    }
    return  __('Showing') . " <b>{$from}</b> " . __('to') . " <b>{$to}</b> " . __('of') . " <b>{$total}</b> " . __('records') . "";
}
function hideAction($status)
{
    if ($status == 2) {
        return 'd-none';
    }
    return '';
}
function orderStatuses($status = null)
{
    return CommonHelper::fetchOrderStatus($status);
}
function badgeForOrderStatuses($status = null)
{
    return CommonHelper::badgeForOrderStatuses($status);
}
function nextOrderStatus($currentStatus)
{
    $allStatuses = orderStatuses();
    $nextOptions = [];
    switch ($currentStatus) {
        case 0:
            $nextOptions = [4];
            break;
        case 1:
            $nextOptions = [2, 4];
            break;
        case 2:
            $nextOptions = [3, 4];
            break;
        case 3:
            $nextOptions = [];
            break;
        case 4:
            $nextOptions = [6];
            break;
        case 5:
            $nextOptions = [6];
            break;

        default:
            $nextOptions = [];
    }
    $options = [];
    foreach ($nextOptions as $key) {
        if (isset($allStatuses[$key])) {
            $options[$key] = $allStatuses[$key];
        }
    }
    // if ($currentStatus == 5 || $currentStatus == 4) {
    //     $options['refund'] = 'Refund';
    // }
    return $options;
}
/**
 * Return the appropriate status flow array based on the final status.
 *
 * @param int|null $currentStatus
 * @return array
 */
function getOrderStatusFlow(Collection $logs, bool $isRefund): array
{
    $hasCancelled = $logs->contains('status', 4);
    $hasReturned = $logs->contains('status', 5);

    $baseStatuses = [0, 1, 2, 3];

    if ($hasCancelled) {
        $flow = [0, 1, 2, 4];
    } elseif ($hasReturned) {
        $flow = [0, 1, 2, 3, 5];
    } else {
        $flow = $baseStatuses;
    }

    if ($isRefund) {
        $flow[] = 6;
    }

    return $flow;
}
function fixedDeptsID()
{
    return [6, 7, 8, 9, 10];
}
function isFinanceUser($user)
{

    return CommonHelper::isFinanceUser($user);
}
