<?php

namespace App\Events;

use App\Models\Message;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ChatMessageEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;
    public $message;
    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(Message $message)
    {
        $message->load('sender');
        $this->message = $message;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('chat.' . $this->message->conversation_id);
    }
    public function broadcastAs()
    {
        return 'new-chat-message';
    }

    public function broadcastWith()
    {
        return [
            'id'           => $this->message->id,
            'conversation_id' => $this->message->conversation_id,
            'sender_id'    => $this->message->sender_id,
            'sender_type'  => class_basename($this->message->sender_type), // "Customer" or "User"
            'message'      => $this->message->message,
            'attachements' => $this->message->attachements,
            'created_at'   => $this->message->created_at->toDateTimeString(),
            'sender'       => [
                'id'    => $this->message->sender->id,
                'name'  => $this->message->sender->name ?? null,
                'avatar_url' => $this->message->sender->avatar_url ?? '/uploads/default.png',
            ]
        ];
    }
}
