<table id="myTable" class="dataTable table table-hover display responsive nowrap">
    <thead>
        <tr>

            <th>
                <span class="sortable" data-sort="title" data-order="asc">
                    title
                    <i id="sort-icon-title" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="status" data-order="asc">
                    Status
                    <i id="sort-icon-status" class="bx bx-sort"></i>
                </span>
            </th>
            <th>
                <span class="sortable" data-sort="created_at" data-order="asc">
                    Created at
                    <i id="sort-icon-created_at" class="bx bx-sort"></i>
                </span>
            </th>

            <th>Actions</th>
        </tr>
    </thead>
    <?php if(isset($wholesale_id_plans) && count($wholesale_id_plans) > 0): ?>
        <tbody class="table-border-bottom-0">

            <?php $__currentLoopData = $wholesale_id_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wholesale_id_plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>

                    <td class="text-capitalize"><?php echo e($wholesale_id_plan->title); ?></td>
                    <td>
                        <span class="badge <?php echo e(badgesforStatuses($wholesale_id_plan->status)); ?>">
                            <?php echo e(basicStatusesDisplay($wholesale_id_plan->status)); ?>

                        </span>

                    </td>
                    <td><?php echo e(dateInList($wholesale_id_plan->created_at)); ?></td>
                    
                    <td class="<?php echo e(hideAction($wholesale_id_plan->status)); ?>">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['delete-wholesale_plan', 'edit-wholesale_plan'])): ?>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class="bx bx-dots-vertical-rounded"></i>
                                </button>
                                <div class="dropdown-menu">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit-wholesale_plan')): ?>
                                        <a class="dropdown-item"
                                            href="<?php echo e(route('admin.wholesale-plan.edit', $wholesale_id_plan->id)); ?>"><i
                                                class="bx bx-edit-alt me-1"></i> Edit</a>
                                    <?php endif; ?>
                                    <?php if(!$wholesale_id_plan->is_default): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete-wholesale_plan')): ?>
                                            <button
                                                data-url="<?php echo e(route('admin.wholesale-plan.destroy', $wholesale_id_plan->id)); ?>"
                                                data-id="<?php echo e($wholesale_id_plan->id); ?>" type="button"
                                                class="dropdown-item delete-btn" href="javascript:void(0);"><i
                                                    class="bx bx-trash me-1"></i>
                                                Delete</button>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>


                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <td class="" colspan="6">
                    <div class="mt-2 row justify-space-between mb-2">
                        <div class="col-md-6">
                            <div class="" id="records"><?php echo pageInfo($wholesale_id_plans); ?></div>
                        </div>
                        <div class="col-md-6 pagination-end">

                            <?php echo $wholesale_id_plans->links('pagination::bootstrap-4'); ?>


                        </div>
                    </div>
                </td>
            </tr>
        </tfoot>

    <?php endif; ?>
</table>
<?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/wholesleId/pagination.blade.php ENDPATH**/ ?>