
<?php $__env->startSection('title', 'Welcome to AAA Admin Dashboard'); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <section>
            <div class="container py-5">

                <div class="row">

                    <div class="chat-sidebar col-md-6 col-lg-5 col-xl-4 mb-4 mb-md-0 ">

                        <h5 class="font-weight-bold mb-3 text-center text-lg-start">Conversation</h5>

                        <div class="card">
                            <div class="card-body">
                                <ul class="list-unstyled mb-0">
                                    <?php $__empty_1 = true; $__currentLoopData = $conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <li class="p-2 border-bottom bg-body-tertiary conversation-item"
                                            data-id="<?php echo e($conversation->id); ?>">
                                            <a href="#" class="d-flex justify-content-between">
                                                <div class="d-flex flex-row">
                                                    <?php if($conversation->customer->image): ?>
                                                        <img src="<?php echo e(asset($conversation->customer->image)); ?>"
                                                            alt="avatar"
                                                            class="rounded-circle d-flex align-self-center me-3 shadow-1-strong"
                                                            width="60">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset(DEFAULT_PATH)); ?>" alt="avatar"
                                                            class="rounded-circle d-flex align-self-center me-3 shadow-1-strong"
                                                            width="60">
                                                    <?php endif; ?>

                                                    <div class="pt-1">
                                                        <p class="fw-bold mb-0"> <?php echo e($conversation->customer->full_name); ?>

                                                        </p>
                                                        <p class="small text-muted">
                                                            <?php echo e($conversation->lastMessage?->message); ?></p>

                                                    </div>
                                                </div>
                                                <div class="pt-1">
                                                    <p class="small text-muted mb-1">Just now</p>
                                                    <?php if(!$conversation->lastMessage?->is_read): ?>
                                                        <span class="badge bg-danger float-end">1</span>
                                                    <?php endif; ?>

                                                </div>
                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <li>
                                            <p class="text-mute">No Conversation available yet!</p>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>

                    </div>
                    
                    <div class=" col-md-6 col-lg-7 col-xl-8">
                        <div class="chat-messages">
                            <ul class="list-unstyled" id="messages-list">
                                


                            </ul>
                        </div>
                        <div class="chat-input mt-3">
                            <div class="form-outline">
                                <textarea class="form-control bg-body-tertiary" id="message-input" rows="3" placeholder="Type your message..."></textarea>
                            </div>
                            <div class="text-end mt-2">
                                <button type="button" id="send-btn" class="btn btn-info btn-rounded">Send</button>
                            </div>
                        </div>

                    </div>

                </div>

            </div>
        </section>

    </div>
    <!-- / Content -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        // Scroll to bottom when messages load
        function scrollToBottom() {
            const chatMessages = document.querySelector('.chat-messages');
            chatMessages.scrollTop = chatMessages.scrollHeight;
        }

        // Call once when page loads
        document.addEventListener('DOMContentLoaded', scrollToBottom);

        // Call again after sending or receiving a message
        document.getElementById('send-btn').addEventListener('click', function() {
            // Your message sending logic here ...
            scrollToBottom();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\aaa\resources\views/admin/chat/index.blade.php ENDPATH**/ ?>