<?php $__env->startSection('title', 'Welcome to AAA Admin Dashboard'); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <section>
            <div class="container py-3">

                <div class="row">

                    <div class="chat-sidebar col-md-6 col-lg-5 col-xl-4 mb-4 mb-md-0 ">

                        <h5 class="font-weight-bold mb-3 text-center text-lg-start">Conversation</h5>

                        <div class="card">
                            <div class="card-body">
                                <ul class="list-unstyled mb-0">
                                    <?php $__empty_1 = true; $__currentLoopData = $conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <li class="p-2 border-bottom bg-body-tertiary conversation-item"
                                            data-id="<?php echo e($conversation->id); ?>">
                                            <a href="#" class="d-flex justify-content-between">
                                                <div class="d-flex flex-row">
                                                    <?php if($conversation->customer && $conversation->customer->image && $conversation->customer->deleted_at === null): ?>
                                                        <img src="<?php echo e(asset($conversation->customer?->image)); ?>"
                                                            alt="avatar"
                                                            class="rounded-circle d-flex align-self-center me-3 shadow-1-strong"
                                                            width="60">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset(DEFAULT_PATH)); ?>" alt="avatar"
                                                            class="rounded-circle d-flex align-self-center me-3 shadow-1-strong"
                                                            width="60">
                                                    <?php endif; ?>

                                                    <div class="pt-1">
                                                        <div class="d-flex">
                                                            <p class="fw-bold mb-0">
                                                                <?php echo e($conversation->customer?->full_name); ?>


                                                            </p>
                                                            <?php if($conversation->customer?->deleted_at): ?>
                                                                <span class="small">&nbsp;(Deleted)</span>
                                                            <?php endif; ?>
                                                        </div>

                                                        <p
                                                            class="small 
                                                         <?php if(!$conversation->lastMessage?->is_read): ?> text-dark
                                                         <?php else: ?>
                                                         text-muted <?php endif; ?>">
                                                            <?php echo e($conversation->lastMessage?->message); ?></p>

                                                    </div>
                                                </div>
                                                <div class="pt-1">
                                                    <p class="small text-muted mb-1"><?php echo e($conversation->last_message_time); ?>

                                                    </p>
                                                    <?php if(!$conversation->lastMessage?->is_read): ?>
                                                        <span class="badge bg-danger float-end">1</span>
                                                    <?php endif; ?>

                                                </div>
                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <li>
                                            <p class="text-mute">No Conversation available yet!</p>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>

                    </div>
                    

                    <div class=" col-md-6 col-lg-7 col-xl-8">
                        
                        <div class="chat-messages" style="height: 500px; overflow-y: auto;">
                            <ul class="list-unstyled" id="messages-list">
                                


                            </ul>
                        </div>
                        <div class="main-tray mt-2">
                            <div data-mdb-input-init class="form-outline">
                                <input type="text" id="message-input" class="form-control"
                                    placeholder="Type a message..." required />
                                <label for="msg_media1" class="file-label">
                                    <i class="fas fa-paperclip"></i>
                                </label>
                                <input type="file" name="msg_media" id="msg_media1" />
                                <button type="button" id="send-btn" data-mdb-button-init data-mdb-ripple-init
                                    class="btn btn-info btn-rounded float-end">Send</button>
                            </div>
                        </div>


                    </div>

                </div>

            </div>
        </section>

    </div>
    <!-- / Content -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        // Scroll to bottom when messages load
        function scrollToBottom() {
            const chatMessages = document.querySelector('.chat-messages');
            chatMessages.scrollTop = chatMessages.scrollHeight;
        }

        // Call once when page loads
        document.addEventListener('DOMContentLoaded', function() {
            scrollToBottom();
        });

        // Call again after sending or receiving a message
        document.getElementById('send-btn').addEventListener('click', function() {
            // Your message sending logic here ...
            setTimeout(scrollToBottom, 200);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/intellisensetech/public_html/aaa/resources/views/admin/chat/index.blade.php ENDPATH**/ ?>